"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableRuleActions = void 0;
var _keys = require("@kbn/security-solution-features/keys");
var _connector_types = require("@kbn/stack-connectors-plugin/server/connector_types");
var _config = require("@kbn/actions-plugin/server/config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTERNAL_RULE_ACTIONS = [_connector_types.IndexConnectorTypeId, _connector_types.SlackWebhookConnectorTypeId, _connector_types.EmailConnectorTypeId];

/**
 * enable rule actions based on AppFeature Config
 */
const enableRuleActions = ({
  actions,
  appFeatureKeys
}) => {
  if (appFeatureKeys.includes(_keys.AppFeatureSecurityKey.externalRuleActions)) {
    // enables all rule actions
    actions.setEnabledConnectorTypes([_config.EnabledActionTypes.Any]);
  } else {
    actions.setEnabledConnectorTypes(INTERNAL_RULE_ACTIONS);
  }
};
exports.enableRuleActions = enableRuleActions;