"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCloudProductTier = exports.cloudSecurityMetringCallback = void 0;
var _product = require("../../common/product");
var _cloud_security_metering_task = require("./cloud_security_metering_task");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cloudSecurityMetringCallback = async ({
  esClient,
  cloudSetup,
  logger,
  taskId,
  lastSuccessfulReport,
  config
}) => {
  var _cloudSetup$serverles, _cloudSetup$serverles2;
  const projectId = (cloudSetup === null || cloudSetup === void 0 ? void 0 : (_cloudSetup$serverles = cloudSetup.serverless) === null || _cloudSetup$serverles === void 0 ? void 0 : _cloudSetup$serverles.projectId) || 'missing_project_id';
  if (!(cloudSetup !== null && cloudSetup !== void 0 && (_cloudSetup$serverles2 = cloudSetup.serverless) !== null && _cloudSetup$serverles2 !== void 0 && _cloudSetup$serverles2.projectId)) {
    logger.error('no project id found');
  }
  const tier = getCloudProductTier(config);
  try {
    const cloudSecuritySolutions = [_constants.CSPM, _constants.KSPM, _constants.CNVM, _constants.CLOUD_DEFEND];
    const cloudSecurityUsageRecords = await Promise.all(cloudSecuritySolutions.map(cloudSecuritySolution => (0, _cloud_security_metering_task.getCloudSecurityUsageRecord)({
      esClient,
      projectId,
      logger,
      taskId,
      lastSuccessfulReport,
      cloudSecuritySolution,
      tier
    })));

    // remove any potential undefined values from the array,
    return cloudSecurityUsageRecords.filter(record => record !== undefined && record.length > 0).flatMap(record => record);
  } catch (err) {
    logger.error(`Failed to fetch Cloud Security metering data ${err}`);
    return [];
  }
};
exports.cloudSecurityMetringCallback = cloudSecurityMetringCallback;
const getCloudProductTier = config => {
  const cloud = config.productTypes.find(productType => productType.product_line === _product.ProductLine.cloud);
  const tier = cloud ? cloud.product_tier : 'none';
  return tier;
};
exports.getCloudProductTier = getCloudProductTier;