"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyProtections = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CARD_TITLE = _i18n.i18n.translate('xpack.securitySolutionServerless.endpointPolicyProtections.cardTitle', {
  defaultMessage: 'Policy Protections'
});
const CARD_MESSAGE = _i18n.i18n.translate('xpack.securitySolutionServerless.endpointPolicyProtections.cardMessage', {
  defaultMessage: 'To turn on policy protections, like malware, ransomware and others, you must add at least Endpoint Essentials to your project. '
});
const BADGE_TEXT = _i18n.i18n.translate('xpack.securitySolutionServerless.endpointPolicyProtections.badgeText', {
  defaultMessage: 'Endpoint Essentials'
});
const CardDescription = _styled.default.p`
  padding: 0 33.3%;
`;

/**
 * Component displayed when a given product tier is not allowed to use endpoint policy protections.
 */
const EndpointPolicyProtections = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "endpointPolicy-protectionsLockedCard",
    isDisabled: true,
    description: false,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "lock"
    }),
    betaBadgeProps: {
      'data-test-subj': 'endpointPolicy-protectionsLockedCard-badge',
      label: BADGE_TEXT
    },
    title: /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "endpointPolicy-protectionsLockedCard-title"
    }, /*#__PURE__*/_react.default.createElement("strong", null, CARD_TITLE))
  }, /*#__PURE__*/_react.default.createElement(CardDescription, null, CARD_MESSAGE));
});
exports.EndpointPolicyProtections = EndpointPolicyProtections;
EndpointPolicyProtections.displayName = 'EndpointPolicyProtections';