"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsellingSections = exports.upsellingPages = exports.upsellingMessages = exports.registerUpsellings = void 0;
var _common = require("@kbn/security-solution-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _messages = require("@kbn/security-solution-upselling/messages");
var _keys = require("@kbn/security-solution-features/keys");
var _endpoint_management = require("./sections/endpoint_management");
var _pli_features = require("../../common/pli/pli_features");
var _lazy_upselling = require("./lazy_upselling");
var _use_product_type_by_pli = require("./hooks/use_product_type_by_pli");
var _services = require("../common/services");
var _getProductTypeByPLI2;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const registerUpsellings = (upselling, productTypes, services) => {
  const enabledPLIsSet = new Set((0, _pli_features.getProductAppFeatures)(productTypes));
  const upsellingPagesToRegister = upsellingPages.reduce((pageUpsellings, {
    pageName,
    pli,
    component
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      pageUpsellings[pageName] = (0, _services.withServicesProvider)(component, services);
    }
    return pageUpsellings;
  }, {});
  const upsellingSectionsToRegister = upsellingSections.reduce((sectionUpsellings, {
    id,
    pli,
    component
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      sectionUpsellings[id] = component;
    }
    return sectionUpsellings;
  }, {});
  const upsellingMessagesToRegister = upsellingMessages.reduce((messagesUpsellings, {
    id,
    pli,
    message
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      messagesUpsellings[id] = message;
    }
    return messagesUpsellings;
  }, {});
  upselling.setPages(upsellingPagesToRegister);
  upselling.setSections(upsellingSectionsToRegister);
  upselling.setMessages(upsellingMessagesToRegister);
};

// Upselling for entire pages, linked to a SecurityPageName
exports.registerUpsellings = registerUpsellings;
const upsellingPages = [
// It is highly advisable to make use of lazy loaded components to minimize bundle size.
{
  pageName: _common.SecurityPageName.entityAnalytics,
  pli: _keys.AppFeatureKey.advancedInsights,
  component: () => {
    var _getProductTypeByPLI;
    return /*#__PURE__*/_react.default.createElement(_lazy_upselling.EntityAnalyticsUpsellingLazy, {
      requiredProduct: (_getProductTypeByPLI = (0, _use_product_type_by_pli.getProductTypeByPLI)(_keys.AppFeatureKey.advancedInsights)) !== null && _getProductTypeByPLI !== void 0 ? _getProductTypeByPLI : undefined
    });
  }
}, {
  pageName: _common.SecurityPageName.threatIntelligence,
  pli: _keys.AppFeatureKey.threatIntelligence,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.ThreatIntelligencePaywallLazy, {
    requiredPLI: _keys.AppFeatureKey.threatIntelligence
  })
}, {
  pageName: _common.SecurityPageName.exceptions,
  pli: _keys.AppFeatureKey.endpointExceptions,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.EndpointExceptionsDetailsUpsellingLazy, {
    requiredPLI: _keys.AppFeatureKey.endpointExceptions
  })
}];

// Upselling for sections, linked by arbitrary ids
exports.upsellingPages = upsellingPages;
const upsellingSections = [
// It is highly advisable to make use of lazy loaded components to minimize bundle size.
{
  id: 'osquery_automated_response_actions',
  pli: _keys.AppFeatureKey.osqueryAutomatedResponseActions,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.OsqueryResponseActionsUpsellingSectionLazy, {
    requiredPLI: _keys.AppFeatureKey.osqueryAutomatedResponseActions
  })
}, {
  id: 'endpointPolicyProtections',
  pli: _keys.AppFeatureKey.endpointPolicyProtections,
  component: _endpoint_management.EndpointPolicyProtectionsLazy
}, {
  id: 'ruleDetailsEndpointExceptions',
  pli: _keys.AppFeatureKey.endpointExceptions,
  component: _endpoint_management.RuleDetailsEndpointExceptionsLazy
}];

// Upselling for sections, linked by arbitrary ids
exports.upsellingSections = upsellingSections;
const upsellingMessages = [{
  id: 'investigation_guide',
  pli: _keys.AppFeatureKey.investigationGuide,
  message: (0, _messages.UPGRADE_INVESTIGATION_GUIDE)((_getProductTypeByPLI2 = (0, _use_product_type_by_pli.getProductTypeByPLI)(_keys.AppFeatureKey.investigationGuide)) !== null && _getProductTypeByPLI2 !== void 0 ? _getProductTypeByPLI2 : '')
}];
exports.upsellingMessages = upsellingMessages;