"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectNavigationTree = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _chrome_navigation_tree = require("./chrome_navigation_tree");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This class is temporary until we can remove the chrome navigation tree and use only the formatNavigationTree
 */
class ProjectNavigationTree {
  constructor(services) {
    (0, _defineProperty2.default)(this, "projectNavLinks$", void 0);
    this.services = services;
    const {
      getProjectNavLinks$
    } = this.services;
    this.projectNavLinks$ = getProjectNavLinks$();
  }
  getChromeNavigationTree$() {
    const formatChromeProjectNavNodes = (0, _chrome_navigation_tree.getFormatChromeProjectNavNodes)(this.services);
    return this.projectNavLinks$.pipe((0, _rxjs.map)(projectNavLinks => formatChromeProjectNavNodes(projectNavLinks)));
  }
}
exports.ProjectNavigationTree = ProjectNavigationTree;