"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.projectSettingsNavLinks = exports.createProjectSettingsLinksFromManage = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("./project_settings_translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createProjectSettingsLinksFromManage = manageLink => {
  var _manageLink$links;
  const entityAnalyticsLink = (_manageLink$links = manageLink.links) === null || _manageLink$links === void 0 ? void 0 : _manageLink$links.find(({
    id
  }) => id === _securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement);
  return entityAnalyticsLink ? [{
    ...entityAnalyticsLink,
    sideNavDisabled: true // Link disabled from the side nav but configured in the navigationTree (breadcrumbs). It is displayed in the management cards landing.
  }] : [];
};
exports.createProjectSettingsLinksFromManage = createProjectSettingsLinksFromManage;
const projectSettingsNavLinks = [{
  id: _constants.ExternalPageName.management,
  title: i18n.MANAGEMENT_TITLE
}, {
  id: _constants.ExternalPageName.integrationsSecurity,
  title: i18n.INTEGRATIONS_TITLE
}, {
  id: _constants.ExternalPageName.cloudUsersAndRoles,
  title: i18n.CLOUD_USERS_ROLES_TITLE
}, {
  id: _constants.ExternalPageName.cloudBilling,
  title: i18n.CLOUD_BILLING_TITLE
}, {
  id: _constants.ExternalPageName.maps,
  title: i18n.MAPS_TITLE,
  description: i18n.MAPS_DESCRIPTION,
  landingIcon: 'graphApp',
  disabled: true // Link disabled from the side nav but configured in the navigationTree (breadcrumbs). It is displayed in the management cards landing.
}, {
  id: _constants.ExternalPageName.visualize,
  title: i18n.VISUALIZE_TITLE,
  description: i18n.VISUALIZE_DESCRIPTION,
  landingIcon: 'visualizeApp',
  disabled: true // Link disabled from the side nav but configured in the navigationTree (breadcrumbs). It is displayed in the management cards landing.
}];
exports.projectSettingsNavLinks = projectSettingsNavLinks;