"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startNavigation = exports.setupNavigation = void 0;
var _common = require("@kbn/security-solution-plugin/common");
var _services = require("../common/services");
var _breadcrumbs = require("./breadcrumbs");
var _navigation_tree = require("./navigation_tree");
var _side_navigation = require("./side_navigation");
var _project_navigation = require("./project_navigation");
var _app_links = require("./links/app_links");
var _deep_links = require("./links/deep_links");
var _management_cards = require("./management_cards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setupNavigation = (_core, {
  securitySolution
}) => {
  securitySolution.setAppLinksSwitcher(_app_links.projectAppLinksSwitcher);
  securitySolution.setDeepLinksFormatter(_deep_links.formatProjectDeepLinks);
};
exports.setupNavigation = setupNavigation;
const startNavigation = services => {
  const {
    serverless,
    management
  } = services;
  serverless.setProjectHome(_common.APP_PATH);
  (0, _management_cards.enableManagementCardsLanding)(services);
  const projectNavigationTree = new _navigation_tree.ProjectNavigationTree(services);
  if (services.experimentalFeatures.platformNavEnabled) {
    const SideNavComponentWithServices = (0, _services.withServicesProvider)(_project_navigation.SecuritySideNavComponent, services);
    serverless.setSideNavComponent(SideNavComponentWithServices);
  } else {
    projectNavigationTree.getChromeNavigationTree$().subscribe(chromeNavigationTree => {
      serverless.setNavigation({
        navigationTree: chromeNavigationTree
      });
    });
    serverless.setSideNavComponent((0, _side_navigation.getSecuritySideNavComponent)(services));
  }
  management.setIsSidebarEnabled(false);
  (0, _breadcrumbs.subscribeBreadcrumbs)(services);
};
exports.startNavigation = startNavigation;