"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCardStepStyles = exports.HEIGHT_ANIMATION_DURATION = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HEIGHT_ANIMATION_DURATION = 250;
exports.HEIGHT_ANIMATION_DURATION = HEIGHT_ANIMATION_DURATION;
const useCardStepStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const completeStepBackgroundColor = (0, _eui.useEuiBackgroundColor)('success');
  const customStyles = (0, _react2.useMemo)(() => ({
    stepPanelStyles: (0, _react.css)`
        .stepContentWrapper {
          display: grid;
          grid-template-rows: 1fr;
          transition: grid-template-rows ${HEIGHT_ANIMATION_DURATION}ms ease-in;
        }

        &.step-panel-collapsed .stepContentWrapper {
          grid-template-rows: 0fr;
        }

        .stepContent {
          overflow: hidden;
        }
      `,
    getStepGroundStyles: ({
      hasStepContent
    }) => (0, _react.css)`
        cursor: ${hasStepContent ? 'pointer' : 'default'};
        gap: ${euiTheme.size.base};
      `,
    stepItemStyles: (0, _react.css)`
        align-self: center;
      `,
    stepIconStyles: (0, _react.css)`
        &.step-icon {
          border-radius: 50%;
          width: ${euiTheme.size.xxxl};
          height: ${euiTheme.size.xxxl};
          padding: ${euiTheme.size.m};
          background-color: ${euiTheme.colors.body};
        }

        &.step-icon-done {
          background-color: ${completeStepBackgroundColor};
        }
      `,
    stepTitleStyles: (0, _react.css)`
        &.step-title {
          padding-right: ${euiTheme.size.m};
          line-height: ${euiTheme.size.xxxl};
          font-size: ${euiTheme.base * 0.875}px;
          font-weight: ${euiTheme.font.weight.semiBold};
          vertical-align: middle;
        }
      `,
    allDoneTextStyles: (0, _react.css)`
        &.all-done-badge {
          background-color: ${completeStepBackgroundColor};
          color: ${euiTheme.colors.successText};
        }
      `,
    toggleButtonStyles: (0, _react.css)`
        &.toggle-button {
          margin-left: ${euiTheme.base * 0.375}px;
        }
      `
  }), [completeStepBackgroundColor, euiTheme.base, euiTheme.colors.body, euiTheme.colors.successText, euiTheme.font.weight.semiBold, euiTheme.size.base, euiTheme.size.m, euiTheme.size.xxxl]);
  return customStyles;
};
exports.useCardStepStyles = useCardStepStyles;