"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStartedStorage = exports.defaultExpandedCards = exports.FINISHED_STEPS_STORAGE_KEY = exports.EXPANDED_CARDS_STORAGE_KEY = exports.ACTIVE_PRODUCTS_STORAGE_KEY = void 0;
var _types = require("./types");
var _storage = require("../common/lib/storage");
var _helpers = require("./helpers");
var _sections = require("./sections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTIVE_PRODUCTS_STORAGE_KEY = 'securitySolution.getStarted.activeProducts';
exports.ACTIVE_PRODUCTS_STORAGE_KEY = ACTIVE_PRODUCTS_STORAGE_KEY;
const FINISHED_STEPS_STORAGE_KEY = 'securitySolution.getStarted.finishedSteps';
exports.FINISHED_STEPS_STORAGE_KEY = FINISHED_STEPS_STORAGE_KEY;
const EXPANDED_CARDS_STORAGE_KEY = 'securitySolution.getStarted.expandedCards';
exports.EXPANDED_CARDS_STORAGE_KEY = EXPANDED_CARDS_STORAGE_KEY;
const defaultExpandedCards = {
  [_types.QuickStartSectionCardsId.watchTheOverviewVideo]: {
    isExpanded: false,
    expandedSteps: []
  },
  [_types.QuickStartSectionCardsId.createFirstProject]: {
    isExpanded: false,
    expandedSteps: []
  },
  [_types.AddAndValidateYourDataCardsId.addIntegrations]: {
    isExpanded: false,
    expandedSteps: []
  },
  [_types.AddAndValidateYourDataCardsId.viewDashboards]: {
    isExpanded: false,
    expandedSteps: []
  },
  [_types.GetStartedWithAlertsCardsId.enablePrebuiltRules]: {
    isExpanded: false,
    expandedSteps: []
  },
  [_types.GetStartedWithAlertsCardsId.viewAlerts]: {
    isExpanded: false,
    expandedSteps: []
  }
};
exports.defaultExpandedCards = defaultExpandedCards;
const getStartedStorage = {
  setDefaultFinishedSteps: cardId => {
    var _allFinishedSteps$car;
    const allFinishedSteps = _storage.storage.get(FINISHED_STEPS_STORAGE_KEY);
    const defaultFinishedStepsByCardId = _helpers.defaultFinishedSteps[cardId];
    const hasDefaultFinishedSteps = defaultFinishedStepsByCardId != null;
    if (!hasDefaultFinishedSteps) {
      return;
    }
    _storage.storage.set(FINISHED_STEPS_STORAGE_KEY, {
      ...allFinishedSteps,
      [cardId]: Array.from(
      // dedupe card steps
      new Set([...(defaultFinishedStepsByCardId !== null && defaultFinishedStepsByCardId !== void 0 ? defaultFinishedStepsByCardId : []), ...((_allFinishedSteps$car = allFinishedSteps[cardId]) !== null && _allFinishedSteps$car !== void 0 ? _allFinishedSteps$car : [])]))
    });
  },
  getActiveProductsFromStorage: () => {
    const activeProducts = _storage.storage.get(ACTIVE_PRODUCTS_STORAGE_KEY);
    return activeProducts !== null && activeProducts !== void 0 ? activeProducts : [];
  },
  toggleActiveProductsInStorage: productId => {
    var _storage$get;
    const activeProducts = (_storage$get = _storage.storage.get(ACTIVE_PRODUCTS_STORAGE_KEY)) !== null && _storage$get !== void 0 ? _storage$get : [];
    const index = activeProducts.indexOf(productId);
    if (index < 0) {
      activeProducts.push(productId);
    } else {
      activeProducts.splice(index, 1);
    }
    _storage.storage.set(ACTIVE_PRODUCTS_STORAGE_KEY, activeProducts);
    return activeProducts;
  },
  getFinishedStepsFromStorageByCardId: cardId => {
    var _finishedSteps$cardId;
    const finishedSteps = getStartedStorage.getAllFinishedStepsFromStorage();
    const steps = (_finishedSteps$cardId = finishedSteps[cardId]) !== null && _finishedSteps$cardId !== void 0 ? _finishedSteps$cardId : [];
    return steps;
  },
  getAllFinishedStepsFromStorage: () => {
    const allFinishedSteps = _storage.storage.get(FINISHED_STEPS_STORAGE_KEY);
    if (allFinishedSteps == null) {
      _storage.storage.set(FINISHED_STEPS_STORAGE_KEY, _helpers.defaultFinishedSteps);
    } else {
      (0, _sections.getSections)().forEach(section => {
        var _section$cards;
        (_section$cards = section.cards) === null || _section$cards === void 0 ? void 0 : _section$cards.forEach(card => {
          getStartedStorage.setDefaultFinishedSteps(card.id);
        });
      });
    }
    return _storage.storage.get(FINISHED_STEPS_STORAGE_KEY);
  },
  addFinishedStepToStorage: (cardId, stepId) => {
    var _finishedSteps$cardId2;
    const finishedSteps = getStartedStorage.getAllFinishedStepsFromStorage();
    const card = (_finishedSteps$cardId2 = finishedSteps[cardId]) !== null && _finishedSteps$cardId2 !== void 0 ? _finishedSteps$cardId2 : [];
    if (card.indexOf(stepId) < 0) {
      card.push(stepId);
      _storage.storage.set(FINISHED_STEPS_STORAGE_KEY, {
        ...finishedSteps,
        [cardId]: card
      });
    }
  },
  removeFinishedStepFromStorage: (cardId, stepId) => {
    var _finishedSteps$cardId3;
    if ((0, _helpers.isDefaultFinishedCardStep)(cardId, stepId)) {
      return;
    }
    const finishedSteps = getStartedStorage.getAllFinishedStepsFromStorage();
    const steps = (_finishedSteps$cardId3 = finishedSteps[cardId]) !== null && _finishedSteps$cardId3 !== void 0 ? _finishedSteps$cardId3 : [];
    const index = steps.indexOf(stepId);
    if (index >= 0) {
      steps.splice(index, 1);
    }
    _storage.storage.set(FINISHED_STEPS_STORAGE_KEY, {
      ...finishedSteps,
      [cardId]: steps
    });
  },
  getAllExpandedCardStepsFromStorage: () => {
    const storageData = _storage.storage.get(EXPANDED_CARDS_STORAGE_KEY);
    return !storageData || Object.keys(storageData).length === 0 ? defaultExpandedCards : storageData;
  },
  resetAllExpandedCardStepsToStorage: () => {
    const activeCards = getStartedStorage.getAllExpandedCardStepsFromStorage();
    _storage.storage.set(EXPANDED_CARDS_STORAGE_KEY, Object.entries(activeCards).reduce((acc, [cardId, card]) => {
      var _defaultExpandedCards;
      acc[cardId] = (_defaultExpandedCards = defaultExpandedCards[cardId]) !== null && _defaultExpandedCards !== void 0 ? _defaultExpandedCards : card;
      return acc;
    }, {}));
  },
  addExpandedCardStepToStorage: (cardId, stepId) => {
    const activeCards = getStartedStorage.getAllExpandedCardStepsFromStorage();
    const card = activeCards[cardId] ? {
      expandedSteps: [stepId],
      isExpanded: true
    } : {
      isExpanded: false,
      expandedSteps: []
    };
    _storage.storage.set(EXPANDED_CARDS_STORAGE_KEY, {
      ...activeCards,
      [cardId]: card
    });
  },
  removeExpandedCardStepFromStorage: (cardId, stepId) => {
    var _storage$get2;
    const activeCards = (_storage$get2 = _storage.storage.get(EXPANDED_CARDS_STORAGE_KEY)) !== null && _storage$get2 !== void 0 ? _storage$get2 : {};
    const card = activeCards[cardId];
    if (card && !stepId) {
      card.isExpanded = false;
    }
    if (card && stepId) {
      const index = card.expandedSteps.indexOf(stepId);
      if (index >= 0) {
        card.expandedSteps.splice(index, 1);
        card.isExpanded = false;
      }
    }
    _storage.storage.set(EXPANDED_CARDS_STORAGE_KEY, {
      ...activeCards,
      [cardId]: card
    });
  }
};
exports.getStartedStorage = getStartedStorage;