"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetUpSections = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _card_item = require("../card_item");
var _sections = require("../sections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSetUpSections = ({
  euiTheme
}) => {
  const setUpCards = (0, _react.useCallback)(({
    activeSections,
    expandedCardSteps,
    finishedSteps,
    toggleTaskCompleteStatus,
    onStepClicked,
    sectionId
  }) => {
    var _Object$values;
    const section = activeSections === null || activeSections === void 0 ? void 0 : activeSections[sectionId];
    return section ? (_Object$values = Object.values(section)) === null || _Object$values === void 0 ? void 0 : _Object$values.map(cardItem => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: cardItem.id
    }, /*#__PURE__*/_react.default.createElement(_card_item.CardItem, {
      activeStepIds: cardItem.activeStepIds,
      cardId: cardItem.id,
      "data-test-subj": cardItem.id,
      expandedCardSteps: expandedCardSteps,
      finishedSteps: finishedSteps[cardItem.id],
      toggleTaskCompleteStatus: toggleTaskCompleteStatus,
      onStepClicked: onStepClicked,
      sectionId: sectionId
    }))) : null;
  }, []);
  const setUpSections = (0, _react.useCallback)(({
    activeSections,
    expandedCardSteps,
    finishedSteps,
    toggleTaskCompleteStatus,
    onStepClicked
  }) => (0, _sections.getSections)().reduce((acc, currentSection) => {
    const cardNodes = setUpCards({
      activeSections,
      expandedCardSteps,
      finishedSteps,
      toggleTaskCompleteStatus,
      onStepClicked,
      sectionId: currentSection.id
    });
    if (cardNodes && cardNodes.length > 0) {
      acc.push( /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        color: "plain",
        element: "div",
        grow: false,
        paddingSize: "none",
        hasShadow: false,
        borderRadius: "none",
        css: (0, _react2.css)`
                margin: ${euiTheme.size.l} 0;
                padding-top: 4px;
                background-color: ${euiTheme.colors.lightestShade};
              `,
        key: currentSection.id,
        id: currentSection.id,
        "data-test-subj": `section-${currentSection.id}`
      }, /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _react2.css)`
                  font-size: ${euiTheme.base * 1.375}px;
                  font-weight: ${euiTheme.font.weight.bold};
                `
      }, currentSection.title), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none",
        direction: "column",
        css: (0, _react2.css)`
                  gap: ${euiTheme.size.base};
                `
      }, cardNodes)));
    }
    return acc;
  }, []), [euiTheme.base, euiTheme.colors.lightestShade, euiTheme.font.weight.bold, euiTheme.size.base, euiTheme.size.l, setUpCards]);
  return {
    setUpSections
  };
};
exports.useSetUpSections = useSetUpSections;