"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScrollToHash = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _card_step = require("../styles/card_step.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HEADER_OFFSET = 40;
const useScrollToHash = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const [documentReadyState, setReadyState] = (0, _react.useState)(document.readyState);
  (0, _react.useEffect)(() => {
    const readyStateListener = () => setReadyState(document.readyState);
    document.addEventListener('readystatechange', readyStateListener);
    return () => document.removeEventListener('readystatechange', readyStateListener);
  }, []);
  (0, _react.useEffect)(() => {
    if (documentReadyState !== 'complete') return; // Wait for page to finish loading before scrolling

    const hash = location.hash.split('?')[0].replace('#', '');
    const element = hash ? document.getElementById(hash) : null;
    if (element) {
      // Wait for transition to complete before scrolling
      setTimeout(() => {
        element.focus({
          preventScroll: true
        }); // Scrolling already handled below

        window.scrollTo({
          top: element.offsetTop - HEADER_OFFSET,
          behavior: 'smooth'
        });
      }, _card_step.HEIGHT_ANIMATION_DURATION);
    }
  }, [location.hash, documentReadyState]);
};
exports.useScrollToHash = useScrollToHash;