"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckStepCompleted = void 0;
var _react = require("react");
var _services = require("../../common/services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCheckStepCompleted = ({
  autoCheckIfStepCompleted,
  cardId,
  indicesExist,
  sectionId,
  stepId,
  stepTitle,
  toggleTaskCompleteStatus
}) => {
  const {
    http: kibanaServicesHttp,
    notifications: {
      toasts
    }
  } = (0, _services.useKibana)().services;
  const abortSignal = (0, _react.useRef)(new AbortController());
  const addError = (0, _react.useRef)(toasts.addError.bind(toasts)).current;
  (0, _react.useEffect)(() => {
    if (!autoCheckIfStepCompleted) {
      return;
    }
    const autoCheckStepCompleted = async () => {
      const isDone = await autoCheckIfStepCompleted({
        indicesExist,
        abortSignal,
        kibanaServicesHttp,
        onError: error => {
          addError(error, {
            title: `Failed to check ${stepTitle !== null && stepTitle !== void 0 ? stepTitle : stepId} completion.`
          });
        }
      });
      toggleTaskCompleteStatus({
        stepId,
        cardId,
        sectionId,
        undo: !isDone
      });
    };
    autoCheckStepCompleted();
    const currentAbortController = abortSignal.current;
    return () => {
      currentAbortController.abort();
    };
  }, [autoCheckIfStepCompleted, stepId, cardId, sectionId, toggleTaskCompleteStatus, kibanaServicesHttp, indicesExist, addError, stepTitle]);
};
exports.useCheckStepCompleted = useCheckStepCompleted;