"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GetStartedComponent = exports.GetStarted = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react2 = require("@emotion/react");
var _toggle_panel = require("./toggle_panel");
var _use_toggle_panel = require("./hooks/use_toggle_panel");
var _product = require("../../common/product");
var _progress_bar = require("./progress_bar");
var _step_context = require("./context/step_context");
var _helpers = require("./helpers");
var _welcome_header = require("./welcome_header");
var _footer = require("./footer");
var _use_scroll = require("./hooks/use_scroll");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetStartedComponent = ({
  productTypes,
  indicesExist
}) => {
  var _productTypes$find;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    onStepClicked,
    toggleTaskCompleteStatus,
    state: {
      activeProducts,
      activeSections,
      finishedSteps,
      totalActiveSteps,
      totalStepsLeft,
      expandedCardSteps
    }
  } = (0, _use_toggle_panel.useTogglePanel)({
    productTypes
  });
  const productTier = (_productTypes$find = productTypes.find(product => product.product_line === _product.ProductLine.security)) === null || _productTypes$find === void 0 ? void 0 : _productTypes$find.product_tier;
  (0, _use_scroll.useScrollToHash)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    restrictWidth: false,
    contentBorder: false,
    grow: true
    /* this is the only page without padding in Security Solution,
     **  ignoring main page wrapper padding using absolute positioning
     */,
    css: (0, _react2.css)`
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        position: absolute;
      `
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: _helpers.CONTENT_WIDTH,
    paddingSize: "xl",
    css: (0, _react2.css)`
          padding: 0 ${euiTheme.size.xxl};
        `
  }, /*#__PURE__*/_react.default.createElement(_welcome_header.WelcomeHeader, {
    productTier: productTier
  })), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: _helpers.CONTENT_WIDTH,
    paddingSize: "none",
    css: (0, _react2.css)`
          background-color: ${euiTheme.colors.lightestShade};
          padding: ${euiTheme.size.xxl} ${euiTheme.size.xxl} ${euiTheme.size.m};
        `
  }, /*#__PURE__*/_react.default.createElement(_progress_bar.Progress, {
    totalActiveSteps: totalActiveSteps,
    totalStepsLeft: totalStepsLeft,
    productTier: productTier
  })), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    bottomBorder: "extended",
    grow: true,
    restrictWidth: _helpers.CONTENT_WIDTH,
    paddingSize: "none",
    css: (0, _react2.css)`
          padding: 0 ${euiTheme.size.xxl} ${euiTheme.size.xxxl};
          background-color: ${euiTheme.colors.lightestShade};
        `
  }, /*#__PURE__*/_react.default.createElement(_step_context.StepContextProvider, {
    expandedCardSteps: expandedCardSteps,
    finishedSteps: finishedSteps,
    indicesExist: !!indicesExist,
    onStepClicked: onStepClicked,
    toggleTaskCompleteStatus: toggleTaskCompleteStatus
  }, /*#__PURE__*/_react.default.createElement(_toggle_panel.TogglePanel, {
    activeProducts: activeProducts,
    activeSections: activeSections
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: true,
    restrictWidth: _helpers.CONTENT_WIDTH,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_footer.Footer, null)));
};
exports.GetStartedComponent = GetStartedComponent;
const GetStarted = /*#__PURE__*/_react.default.memo(GetStartedComponent);

// eslint-disable-next-line import/no-default-export
exports.GetStarted = GetStarted;
var _default = GetStarted;
exports.default = _default;