"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointExceptionsValidator = void 0;
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _base_validator = require("./base_validator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EndpointExceptionsValidator extends _base_validator.BaseValidator {
  static isEndpointException(item) {
    return item.listId === _securitysolutionListConstants.ENDPOINT_LIST_ID;
  }
  async validateHasReadPrivilege() {
    return this.validateHasEndpointExceptionsPrivileges('canReadEndpointExceptions');
  }
  async validateHasWritePrivilege() {
    return this.validateHasEndpointExceptionsPrivileges('canWriteEndpointExceptions');
  }
  async validatePreCreateItem(item) {
    await this.validateHasWritePrivilege();
    return item;
  }
  async validatePreUpdateItem(item) {
    await this.validateHasWritePrivilege();
    return item;
  }
  async validatePreDeleteItem() {
    await this.validateHasWritePrivilege();
  }
  async validatePreGetOneItem() {
    await this.validateHasReadPrivilege();
  }
  async validatePreMultiListFind() {
    await this.validateHasReadPrivilege();
  }
  async validatePreExport() {
    await this.validateHasReadPrivilege();
  }
  async validatePreSingleListFind() {
    await this.validateHasReadPrivilege();
  }
  async validatePreGetListSummary() {
    await this.validateHasReadPrivilege();
  }
}
exports.EndpointExceptionsValidator = EndpointExceptionsValidator;