"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTelemetryDiagnosticsTaskConfig = createTelemetryDiagnosticsTaskConfig;
var _helpers = require("../helpers");
var _constants = require("../constants");
var _filterlists = require("../filterlists");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTelemetryDiagnosticsTaskConfig() {
  return {
    type: 'security:endpoint-diagnostics',
    title: 'Security Solution Telemetry Diagnostics task',
    interval: '5m',
    timeout: '4m',
    version: '1.1.0',
    getLastExecutionTime: _helpers.getPreviousDiagTaskTimestamp,
    runTask: async (taskId, logger, receiver, sender, taskExecutionPeriod) => {
      const startTime = Date.now();
      const taskName = 'Security Solution Telemetry Diagnostics task';
      try {
        if (!taskExecutionPeriod.last) {
          throw new Error('last execution timestamp is required');
        }
        let alertCount = 0;
        for await (const alerts of receiver.fetchDiagnosticAlertsBatch(taskExecutionPeriod.last, taskExecutionPeriod.current)) {
          const processedAlerts = alerts.map(event => (0, _filterlists.copyAllowlistedFields)(_filterlists.filterList.endpointAlerts, event));
          if (alerts.length === 0) {
            (0, _helpers.tlog)(logger, 'no diagnostic alerts retrieved');
            await sender.sendOnDemand(_constants.TASK_METRICS_CHANNEL, [(0, _helpers.createTaskMetric)(taskName, true, startTime)]);
            return alertCount;
          }
          alertCount += alerts.length;
          (0, _helpers.tlog)(logger, `Sending ${alerts.length} diagnostic alerts`);
          await sender.sendOnDemand(_constants.TELEMETRY_CHANNEL_ENDPOINT_ALERTS, processedAlerts);
        }
        await sender.sendOnDemand(_constants.TASK_METRICS_CHANNEL, [(0, _helpers.createTaskMetric)(taskName, true, startTime)]);
        return alertCount;
      } catch (err) {
        await sender.sendOnDemand(_constants.TASK_METRICS_CHANNEL, [(0, _helpers.createTaskMetric)(taskName, false, startTime, err.message)]);
        return 0;
      }
    }
  };
}