"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.events = exports.RISK_SCORE_EXECUTION_SUCCESS_EVENT = exports.RISK_SCORE_EXECUTION_ERROR_EVENT = exports.RISK_SCORE_EXECUTION_CANCELLATION_EVENT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISK_SCORE_EXECUTION_SUCCESS_EVENT = {
  eventType: 'risk_score_execution_success',
  schema: {
    scoresWritten: {
      type: 'long',
      _meta: {
        description: 'Number of risk scores written during this scoring task execution'
      }
    },
    taskDurationInSeconds: {
      type: 'long',
      _meta: {
        description: 'Duration (in seconds) of the current risk scoring task execution'
      }
    },
    interval: {
      type: 'keyword',
      _meta: {
        description: `Configured interval for the current risk scoring task`
      }
    }
  }
};
exports.RISK_SCORE_EXECUTION_SUCCESS_EVENT = RISK_SCORE_EXECUTION_SUCCESS_EVENT;
const RISK_SCORE_EXECUTION_ERROR_EVENT = {
  eventType: 'risk_score_execution_error',
  schema: {}
};
exports.RISK_SCORE_EXECUTION_ERROR_EVENT = RISK_SCORE_EXECUTION_ERROR_EVENT;
const RISK_SCORE_EXECUTION_CANCELLATION_EVENT = {
  eventType: 'risk_score_execution_cancellation',
  schema: {
    scoresWritten: {
      type: 'long',
      _meta: {
        description: 'Number of risk scores written during this scoring task execution'
      }
    },
    taskDurationInSeconds: {
      type: 'long',
      _meta: {
        description: 'Duration (in seconds) of the current risk scoring task execution'
      }
    },
    interval: {
      type: 'keyword',
      _meta: {
        description: `Configured interval for the current risk scoring task`
      }
    }
  }
};
exports.RISK_SCORE_EXECUTION_CANCELLATION_EVENT = RISK_SCORE_EXECUTION_CANCELLATION_EVENT;
const events = [RISK_SCORE_EXECUTION_SUCCESS_EVENT, RISK_SCORE_EXECUTION_ERROR_EVENT, RISK_SCORE_EXECUTION_CANCELLATION_EVENT];
exports.events = events;