"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOrUpdateIndex = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _retry_transient_es_errors = require("./retry_transient_es_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * It's check for index existatnce, and create index
 * or update existing index mappings
 */
const createOrUpdateIndex = async ({
  esClient,
  logger,
  options
}) => {
  try {
    const isIndexExist = await esClient.indices.exists({
      index: options.index
    });
    if (isIndexExist) {
      const response = await esClient.indices.get({
        index: options.index
      });
      const indices = Object.keys(response !== null && response !== void 0 ? response : {});
      logger.info(`${options.index} already exist`);
      if (options.mappings) {
        await Promise.all(indices.map(async index => {
          try {
            await (0, _retry_transient_es_errors.retryTransientEsErrors)(() => esClient.indices.putMapping({
              index,
              body: options.mappings
            }), {
              logger
            });
            logger.info(`Update mappings for ${index}`);
          } catch (err) {
            logger.error(`Failed to PUT mapping for index ${index}: ${err.message}`);
          }
        }));
      }
    } else {
      return esClient.indices.create(options);
    }
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    const fullErrorMessage = `Failed to create index: ${options.index}: ${error.message}`;
    logger.error(fullErrorMessage);
    throw new Error(fullErrorMessage);
  }
};
exports.createOrUpdateIndex = createOrUpdateIndex;