"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateAndPersistRiskScores = void 0;
var _calculate_risk_scores = require("./calculate_risk_scores");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const calculateAndPersistRiskScores = async params => {
  var _scores$host, _scores$user;
  const {
    riskScoreDataClient,
    spaceId,
    ...rest
  } = params;
  const writer = await riskScoreDataClient.getWriter({
    namespace: spaceId
  });
  const {
    after_keys: afterKeys,
    scores
  } = await (0, _calculate_risk_scores.calculateRiskScores)(rest);
  if (!((_scores$host = scores.host) !== null && _scores$host !== void 0 && _scores$host.length) && !((_scores$user = scores.user) !== null && _scores$user !== void 0 && _scores$user.length)) {
    return {
      after_keys: {},
      errors: [],
      scores_written: 0
    };
  }
  const {
    errors,
    docs_written: scoresWritten
  } = await writer.bulk(scores);
  return {
    after_keys: afterKeys,
    errors,
    scores_written: scoresWritten
  };
};
exports.calculateAndPersistRiskScores = calculateAndPersistRiskScores;