"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkCreateUnsuppressedAlerts = void 0;
var _search_after_bulk_create = require("../../utils/search_after_bulk_create");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * searches and bulk creates unsuppressed alerts if any exists
 * @param param0
 * @returns
 */
const bulkCreateUnsuppressedAlerts = async ({
  size,
  groupByFields,
  buildReasonMessage,
  runOpts,
  filter,
  services,
  eventsTelemetry
}) => {
  const bulkCreatedResult = await (0, _search_after_bulk_create.searchAfterAndBulkCreate)({
    tuple: {
      ...runOpts.tuple,
      maxSignals: size
    },
    exceptionsList: [],
    services,
    listClient: runOpts.listClient,
    ruleExecutionLogger: runOpts.ruleExecutionLogger,
    eventsTelemetry,
    inputIndexPattern: runOpts.inputIndex,
    pageSize: runOpts.searchAfterSize,
    filter,
    buildReasonMessage,
    bulkCreate: runOpts.bulkCreate,
    wrapHits: runOpts.wrapHits,
    runtimeMappings: runOpts.runtimeMappings,
    primaryTimestamp: runOpts.primaryTimestamp,
    secondaryTimestamp: runOpts.secondaryTimestamp,
    additionalFilters: buildMissingFieldsFilter(groupByFields)
  });
  return bulkCreatedResult;
};

/**
 * builds filter that returns only docs with at least one missing field from a list of groupByFields fields
 * @param groupByFields
 * @returns - Array<{@link QueryDslQueryContainer}>
 */
exports.bulkCreateUnsuppressedAlerts = bulkCreateUnsuppressedAlerts;
const buildMissingFieldsFilter = groupByFields => {
  if (groupByFields.length === 0) {
    return [];
  }
  return [{
    bool: {
      should: groupByFields.map(field => ({
        bool: {
          must_not: [{
            exists: {
              field
            }
          }]
        }
      }))
    }
  }];
};