"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupHealthRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _rule_monitoring = require("../../../../../../../common/api/detection_engine/rule_monitoring");
var _utils = require("../../../../routes/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Similar to the "setup" command of beats, this endpoint installs resources
 * (dashboards, data views, etc) related to rule monitoring and Detection Engine health,
 * and can do any other setup work.
 */
const setupHealthRoute = router => {
  router.versioned.post({
    access: 'internal',
    path: _rule_monitoring.SETUP_HEALTH_URL,
    options: {
      tags: ['access:securitySolution']
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['securitySolution']);
      const healthClient = ctx.securitySolution.getDetectionEngineHealthClient();
      await healthClient.installAssetsForMonitoringHealth();
      return response.ok({
        body: {}
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.setupHealthRoute = setupHealthRoute;