"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AppClient", {
  enumerable: true,
  get: function () {
    return _types.AppClient;
  }
});
exports.plugin = exports.config = void 0;
var _config = require("./config");
var _constants = require("../common/constants");
var _types = require("./types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const plugin = async context => {
  const {
    Plugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new Plugin(context);
};
exports.plugin = plugin;
const config = {
  exposeToBrowser: {
    enableExperimental: true,
    prebuiltRulesPackageVersion: true,
    offeringSettings: true
  },
  schema: _config.configSchema,
  deprecations: ({
    renameFromRoot,
    unused
  }) => [renameFromRoot('xpack.siem.enabled', 'xpack.securitySolution.enabled', {
    level: 'critical'
  }), renameFromRoot('xpack.siem.maxRuleImportExportSize', 'xpack.securitySolution.maxRuleImportExportSize', {
    level: 'critical'
  }), renameFromRoot('xpack.siem.maxRuleImportPayloadBytes', 'xpack.securitySolution.maxRuleImportPayloadBytes', {
    level: 'critical'
  }), renameFromRoot('xpack.siem.maxTimelineImportExportSize', 'xpack.securitySolution.maxTimelineImportExportSize', {
    level: 'critical'
  }), renameFromRoot('xpack.siem.maxTimelineImportPayloadBytes', 'xpack.securitySolution.maxTimelineImportPayloadBytes', {
    level: 'critical'
  }), renameFromRoot(`xpack.siem.${_constants.SIGNALS_INDEX_KEY}`, `xpack.securitySolution.${_constants.SIGNALS_INDEX_KEY}`, {
    level: 'critical'
  }), unused('ruleExecutionLog.underlyingClient', {
    level: 'warning'
  }), unused('prebuiltRulesFromFileSystem', {
    level: 'warning'
  }), unused('prebuiltRulesFromSavedObjects', {
    level: 'warning'
  })]
};
exports.config = config;