"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeProtectionUpdatesNote = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _pMap = _interopRequireDefault(require("p-map"));
var _saved_object_mappings = require("../../endpoint/lib/protection_updates_note/saved_object_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const removeProtectionUpdatesNote = async (soClient, policy) => {
  if (policy.id) {
    const foundProtectionUpdatesNotes = await soClient.find({
      type: _saved_object_mappings.protectionUpdatesNoteSavedObjectType,
      hasReference: {
        type: _common.PACKAGE_POLICY_SAVED_OBJECT_TYPE,
        id: policy.id
      }
    });
    await (0, _pMap.default)(foundProtectionUpdatesNotes.saved_objects, protectionUpdatesNote => {
      soClient.delete(_saved_object_mappings.protectionUpdatesNoteSavedObjectType, protectionUpdatesNote.id);
    });
  }
};
exports.removeProtectionUpdatesNote = removeProtectionUpdatesNote;