"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateCases = exports.EMPTY_COMMENT = void 0;
var _common = require("@kbn/cases-plugin/common");
var _i18n = require("@kbn/i18n");
var _common2 = require("../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateCases = async ({
  casesClient,
  createActionPayload,
  endpointData
}) => {
  var _createActionPayload$;
  if (!casesClient) {
    return;
  }
  // convert any alert IDs into cases
  let caseIDs = ((_createActionPayload$ = createActionPayload.case_ids) === null || _createActionPayload$ === void 0 ? void 0 : _createActionPayload$.slice()) || [];
  if (createActionPayload.alert_ids && createActionPayload.alert_ids.length > 0) {
    const newIDs = await Promise.all(createActionPayload.alert_ids.map(async alertID => {
      const cases = await casesClient.cases.getCasesByAlertID({
        alertID,
        options: {
          owner: _common2.APP_ID
        }
      });
      return cases.map(caseInfo => {
        return caseInfo.id;
      });
    }));
    caseIDs = caseIDs.concat(...newIDs);
  }
  caseIDs = [...new Set(caseIDs)];

  // Update all cases with a comment
  if (caseIDs.length > 0) {
    const targets = endpointData.map(endpoint => ({
      hostname: endpoint.host.hostname,
      endpointId: endpoint.agent.id
    }));
    const attachments = caseIDs.map(() => ({
      type: _common.AttachmentType.actions,
      comment: createActionPayload.comment || EMPTY_COMMENT,
      actions: {
        targets,
        type: createActionPayload.command
      },
      owner: _common2.APP_ID
    }));
    await Promise.all(caseIDs.map(caseId => casesClient.attachments.bulkCreate({
      caseId,
      attachments
    })));
  }
};
exports.updateCases = updateCases;
const EMPTY_COMMENT = _i18n.i18n.translate('xpack.securitySolution.endpoint.updateCases.emptyComment', {
  defaultMessage: 'No comment provided'
});
exports.EMPTY_COMMENT = EMPTY_COMMENT;