"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.epicPersistNote = exports.createTimelineNoteEpic = void 0;
exports.isNoteAction = isNoteAction;
var _fp = require("lodash/fp");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _actions = require("../../../common/store/app/actions");
var _actions2 = require("./actions");
var _my_epic_timeline_id = require("./my_epic_timeline_id");
var _epic_dispatcher_timeline_persistence_queue = require("./epic_dispatcher_timeline_persistence_queue");
var _api = require("../../containers/notes/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelineNoteActionsType = new Set([_actions2.addNote.type, _actions2.addNoteToEvent.type]);
function isNoteAction(action) {
  return timelineNoteActionsType.has(action.type);
}
const epicPersistNote = (action, notes, action$, timeline$, notes$, allTimelineQuery$) => (0, _rxjs.from)((0, _api.persistNote)({
  noteId: null,
  version: null,
  note: {
    eventId: 'eventId' in action.payload ? action.payload.eventId : undefined,
    note: getNote(action.payload.noteId, notes),
    timelineId: _my_epic_timeline_id.myEpicTimelineId.getTimelineId()
  }
})).pipe((0, _operators.withLatestFrom)(timeline$, notes$, allTimelineQuery$), (0, _operators.mergeMap)(([result, recentTimeline, recentNotes, allTimelineQuery]) => {
  const noteIdRedux = action.payload.noteId;
  const response = (0, _fp.get)('data.persistNote', result);
  const callOutMsg = response.code === 403 ? [(0, _actions2.showCallOutUnauthorizedMsg)()] : [];
  if (allTimelineQuery.refetch != null) {
    allTimelineQuery.refetch();
  }
  return [...callOutMsg, recentTimeline[action.payload.id].savedObjectId == null ? (0, _actions2.updateTimeline)({
    id: action.payload.id,
    timeline: {
      ...recentTimeline[action.payload.id],
      savedObjectId: response.note.timelineId || null,
      version: response.note.timelineVersion || null
    }
  }) : null, (0, _actions.updateNote)({
    note: {
      ...recentNotes[noteIdRedux],
      created: response.note.updated != null ? new Date(response.note.updated) : recentNotes[noteIdRedux].created,
      user: response.note.updatedBy != null ? response.note.updatedBy : recentNotes[noteIdRedux].user,
      saveObjectId: response.note.noteId,
      version: response.note.version
    }
  }), (0, _actions2.endTimelineSaving)({
    id: action.payload.id
  })].filter(Boolean);
}), (0, _operators.startWith)((0, _actions2.startTimelineSaving)({
  id: action.payload.id
})), (0, _operators.takeUntil)(action$.pipe((0, _operators.withLatestFrom)(timeline$), (0, _operators.filter)(([checkAction, updatedTimeline]) => {
  if (checkAction.type === _actions.addError.type) {
    return true;
  }
  if (checkAction.type === _actions2.endTimelineSaving.type && updatedTimeline[(0, _fp.get)('payload.id', checkAction)].savedObjectId != null) {
    _my_epic_timeline_id.myEpicTimelineId.setTimelineId(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].savedObjectId);
    _my_epic_timeline_id.myEpicTimelineId.setTimelineVersion(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].version);
    return true;
  }
  return false;
}))));
exports.epicPersistNote = epicPersistNote;
const createTimelineNoteEpic = () => action$ => action$.pipe((0, _operators.filter)(isNoteAction), (0, _operators.switchMap)(action => {
  _epic_dispatcher_timeline_persistence_queue.dispatcherTimelinePersistQueue.next({
    action
  });
  return _rxjs.EMPTY;
}));
exports.createTimelineNoteEpic = createTimelineNoteEpic;
const getNote = (noteId, notes) => {
  if (noteId != null) {
    return notes[noteId].note;
  }
  return '';
};