"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelineNoteSelector = void 0;
var _reselect = require("reselect");
var _timeline = require("../../../store/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelineNoteSelector = () => (0, _reselect.createSelector)(_timeline.timelineSelectors.selectTimeline, timeline => {
  var _timeline$expandedDet, _timeline$eventIdToNo;
  return {
    createdBy: timeline.createdBy,
    expandedDetail: (_timeline$expandedDet = timeline.expandedDetail) !== null && _timeline$expandedDet !== void 0 ? _timeline$expandedDet : {},
    eventIdToNoteIds: (_timeline$eventIdToNo = timeline === null || timeline === void 0 ? void 0 : timeline.eventIdToNoteIds) !== null && _timeline$eventIdToNo !== void 0 ? _timeline$eventIdToNo : {},
    noteIds: timeline.noteIds,
    status: timeline.status
  };
});
exports.getTimelineNoteSelector = getTimelineNoteSelector;