"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedSearchComparator = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const savedSearchComparator = (inputSavedSearch, existingSavedSearch) => {
  var _inputSavedSearch$sea, _existingSavedSearch$;
  const inputSavedSearchWithFields = {
    ...inputSavedSearch,
    fields: inputSavedSearch === null || inputSavedSearch === void 0 ? void 0 : (_inputSavedSearch$sea = inputSavedSearch.searchSource) === null || _inputSavedSearch$sea === void 0 ? void 0 : _inputSavedSearch$sea.getFields()
  };
  const existingSavedSearchWithFields = {
    ...existingSavedSearch,
    fields: existingSavedSearch === null || existingSavedSearch === void 0 ? void 0 : (_existingSavedSearch$ = existingSavedSearch.searchSource) === null || _existingSavedSearch$ === void 0 ? void 0 : _existingSavedSearch$.getFields()
  };
  const keysToSelect = ['columns', 'grid', 'hideChart', 'sort', 'timeRange', 'fields.filter', 'fields.query', 'title', 'description'];
  const modifiedInputSavedSearch = (0, _lodash.pick)(inputSavedSearchWithFields, keysToSelect);
  const modifiedExistingSavedSearch = (0, _lodash.pick)(existingSavedSearchWithFields, keysToSelect);
  const result = (0, _lodash.isEqual)(modifiedInputSavedSearch, modifiedExistingSavedSearch);
  return result;
};
exports.savedSearchComparator = savedSearchComparator;