"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileDraggable = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileDraggable = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgameFileName,
  endgameFilePath,
  eventId,
  fileExtOriginalPath,
  fileName,
  filePath,
  isDraggable
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(fileName) && (0, _helpers.isNillEmptyOrNotFinite)(endgameFileName) && (0, _helpers.isNillEmptyOrNotFinite)(filePath) && (0, _helpers.isNillEmptyOrNotFinite)(endgameFilePath)) {
    return null;
  }
  const filePathIsKnown = !(0, _helpers.isNillEmptyOrNotFinite)(filePath) || !(0, _helpers.isNillEmptyOrNotFinite)(endgameFilePath);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isNillEmptyOrNotFinite)(fileName) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "file.name",
    isDraggable: isDraggable,
    value: fileName,
    iconType: "document",
    isAggregatable: true,
    fieldType: "keyword"
  })) : !(0, _helpers.isNillEmptyOrNotFinite)(endgameFileName) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "endgame.file_name",
    isDraggable: isDraggable,
    value: endgameFileName,
    iconType: "document",
    isAggregatable: true,
    fieldType: "keyword"
  })) : null, filePathIsKnown && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    "data-test-subj": "in",
    grow: false,
    component: "span"
  }, i18n.IN), !(0, _helpers.isNillEmptyOrNotFinite)(filePath) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "file.path",
    isDraggable: isDraggable,
    value: filePath,
    iconType: "document",
    isAggregatable: true,
    fieldType: "keyword"
  })) : !(0, _helpers.isNillEmptyOrNotFinite)(endgameFilePath) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "endgame.file_path",
    isDraggable: isDraggable,
    value: endgameFilePath,
    iconType: "document",
    isAggregatable: true,
    fieldType: "keyword"
  })) : null, !(0, _helpers.isNillEmptyOrNotFinite)(fileExtOriginalPath) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, i18n.FROM_ITS_ORIGINAL_PATH), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "file.Ext.original.path",
    isDraggable: isDraggable,
    value: fileExtOriginalPath,
    iconType: "document",
    isAggregatable: true,
    fieldType: "keyword"
  }))));
});
exports.FileDraggable = FileDraggable;
FileDraggable.displayName = 'FileDraggable';