"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SESSION = exports.SENT_TO = exports.SENT_TEST = exports.SENT_MESSAGE = exports.SCHEDULED_POLICY_OF = exports.ROTATED_AUDIT_LOGS = exports.RESUMED_AUDIT_LOGGING = exports.RENAMED = exports.REMOVED_USER_ROLE_FROM = exports.REMOTE_AUDIT_DISCONNECTED = exports.REMOTE_AUDIT_CONNECTED = exports.RELABELED_FILESYSTEM = exports.REFRESHED_CREDENTIALS_FOR = exports.RECONFIGURED_AUDIT = exports.RECEIVED_FROM = exports.RAN_COMMAND = exports.OVERRODE_LABEL_OF = exports.OPENED_TOO_MANY_SESSIONS = exports.OPENED_FILE = exports.NEGOTIATED_CRYPTO_KEY = exports.MOUNTED = exports.MODIFIED_USER_ACCOUNT = exports.MODIFIED_ROLE = exports.MODIFIED_LEVEL_OF = exports.MODIFIED_GROUP_ACCOUNT = exports.MIGRATED_VM_TO = exports.MIGRATED_VM_FROM = exports.MADE_DEVICE_WITH = exports.MAC_PERMISSION = exports.LOGGED_OUT = exports.LOCKED_ACCOUNT = exports.LOADED_SELINUX_POLICY = exports.LOADED_MAC_POLICY = exports.LOADED_KERNEL_MODULE = exports.LOADED_FIREWALL_RULE = exports.LISTEN_FOR_CONNECTIONS = exports.KILLED_PROCESS_ID_OF = exports.ISSUED_VM_CONTROL = exports.INITIALIZED_AUDIT_SUBSYSTEM = exports.FAILED_LOGIN_TOO_MANY_TIMES = exports.EXECUTION_OF_FORBIDDEN_PROGRAM = exports.EXECUTED = exports.ERROR_FROM = exports.ENDED_FROM = exports.DISPOSED_CREDENTIALS_TO = exports.DELETED_VM_IMAGE = exports.DELETED_USER_ACCOUNT_USING = exports.DELETED_GROUP_ACCOUNT_USING = exports.DELETED = exports.CRYPTO_OFFICER_LOGGED_OUT = exports.CRYPTO_OFFICER_LOGGED_IN = exports.CREATED_VM_IMAGE = exports.CREATED_DIRECTORY = exports.CRASHED_PROGRAM = exports.CONNECTED_USING = exports.CHECKED_METADATA_OF = exports.CHECKED_INTEGRITY_OF = exports.CHECKED_FILE_SYSTEM_METADATA_OF = exports.CHANGED_USER_ID = exports.CHANGED_TO_RUN_LEVEL_WITH = exports.CHANGED_TIME_STAMP_OF = exports.CHANGED_SYSTEM_TIME_WITH = exports.CHANGED_SYSTEM_NAME = exports.CHANGED_SELINUX_ENFORCEMENT = exports.CHANGED_SELINUX_BOOLEAN = exports.CHANGED_ROLE_USING = exports.CHANGED_PROMISCUOUS_MODE = exports.CHANGED_PASSWORD_WITH = exports.CHANGED_MAC_CONFIGURATION = exports.CHANGED_LOGIN_ID_TO = exports.CHANGED_IDENTITY_USING = exports.CHANGED_GROUP_PASSWORD = exports.CHANGED_GROUP = exports.CHANGED_FILE_PERMISSIONS_OF = exports.CHANGED_FILE_OWNERSHIP_OF = exports.CHANGED_FILE_ATTRIBUTES_OF = exports.CHANGED_CONFIGURATION_WITH = exports.CHANGED_AUDIT_FEATURE = exports.CHANGED_AUDIT_CONFIGURATION = exports.CAUSED_MAC_POLICY_ERROR = exports.BOUND_SOCKET_FROM = exports.BOOTED_SYSTEM = exports.AUTHENTICATED_USING = exports.AUTHENTICATED_TO_GROUP = exports.AUDIT_ERROR = exports.ATTEMPTED_LOGIN_FROM_UNUSUAL_PLACE = exports.ATTEMPTED_LOGIN_FROM_UNUSUAL_HOUR = exports.ATTEMPTED_LOGIN = exports.ASSIGNED_VM_RESOURCE = exports.ASSIGNED_VM_ID = exports.ASSIGNED_USER_ROLE_TO = exports.AS = exports.ALLOCATED_MEMORY_FOR = exports.ADDED_USER_ACCOUNT = exports.ADDED_GROUP_ACCOUNT_USING = exports.ACQUIRED_CREDENTIALS_TO = exports.ACCESS_RESULT = exports.ACCESS_PERMISSION = exports.ACCESS_ERROR = exports.ABORTED_AUDIT_STARTUP = void 0;
exports.WITH_RESULT = exports.WAS_AUTHORIZED_TO_USE = exports.VIOLATED_SELINUX_POLICY = exports.VIOLATED_SECCOMP_POLICY_WITH = exports.VIOLATED_APP_ARMOR_POLICY_FROM = exports.USING = exports.USED_SUSPICIOUS_PROGRAM = exports.UNMOUNTED = exports.UNLOCKED_ACCOUNT = exports.UNLOADED_KERNEL_MODULE_OF = exports.UNKNOWN = exports.TESTED_FILE_SYSTEM_INTEGRITY = exports.SYMLINKED = exports.STOPPED_SERVICE = exports.STARTED_SERVICE = exports.STARTED_CRYPTO_SESSION = exports.STARTED_AUDIT = exports.STARTED = exports.SHUTDOWN_SYSTEM = exports.SHUTDOWN_AUDIT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Note for translators and programmers
// Examples of these strings are all of the form
// Session {session.id} {primary} as {secondary}@{hostname} in {folder} was authorized to use {executable} with result {result.success/failure}
// E.x. Session 5 Frank as root@server-1 in /root was authorized to use wget with result success

// However, the strings can be dropped depending on the circumstances of the variables. For example, with no data at all
// Session 10
// Example with just a user name and hostname
// Session 20 frank@server-1
// Example with user name, hostname, but no result
// Session 20 frank@server-1 acquired credentials to curl

const SESSION = _i18n.i18n.translate('xpack.securitySolution.auditd.sessionDescription', {
  defaultMessage: 'Session'
});
exports.SESSION = SESSION;
const WAS_AUTHORIZED_TO_USE = _i18n.i18n.translate('xpack.securitySolution.auditd.wasAuthorizedToUseDescription', {
  defaultMessage: 'was authorized to use'
});
exports.WAS_AUTHORIZED_TO_USE = WAS_AUTHORIZED_TO_USE;
const ACQUIRED_CREDENTIALS_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.acquiredCredentialsDescription', {
  defaultMessage: 'acquired credentials to'
});
exports.ACQUIRED_CREDENTIALS_TO = ACQUIRED_CREDENTIALS_TO;
const ENDED_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.endedFromDescription', {
  defaultMessage: 'ended from'
});
exports.ENDED_FROM = ENDED_FROM;
const STARTED = _i18n.i18n.translate('xpack.securitySolution.auditd.startedAtDescription', {
  defaultMessage: 'started'
});
exports.STARTED = STARTED;
const DISPOSED_CREDENTIALS_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.disposedCredentialsDescription', {
  defaultMessage: 'disposed credentials to'
});
exports.DISPOSED_CREDENTIALS_TO = DISPOSED_CREDENTIALS_TO;
const ATTEMPTED_LOGIN = _i18n.i18n.translate('xpack.securitySolution.auditd.attemptedLoginDescription', {
  defaultMessage: 'attempted a login via'
});
exports.ATTEMPTED_LOGIN = ATTEMPTED_LOGIN;
const WITH_RESULT = _i18n.i18n.translate('xpack.securitySolution.auditd.withResultDescription', {
  defaultMessage: 'with result'
});
exports.WITH_RESULT = WITH_RESULT;
const EXECUTED = _i18n.i18n.translate('xpack.securitySolution.auditd.executedDescription', {
  defaultMessage: 'executed'
});
exports.EXECUTED = EXECUTED;
const AS = _i18n.i18n.translate('xpack.securitySolution.auditd.asDescription', {
  defaultMessage: 'as'
});
exports.AS = AS;
const CONNECTED_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.connectedUsingDescription', {
  defaultMessage: 'connected using'
});
exports.CONNECTED_USING = CONNECTED_USING;
const USING = _i18n.i18n.translate('xpack.securitySolution.auditd.usingDescription', {
  defaultMessage: 'using'
});
exports.USING = USING;
const OPENED_FILE = _i18n.i18n.translate('xpack.securitySolution.auditd.OpenedFileDescription', {
  defaultMessage: 'opened file'
});
exports.OPENED_FILE = OPENED_FILE;
const CHANGED_FILE_ATTRIBUTES_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.ChangedFileAttributesOfDescription', {
  defaultMessage: 'changed file attributes of'
});
exports.CHANGED_FILE_ATTRIBUTES_OF = CHANGED_FILE_ATTRIBUTES_OF;
const CHANGED_FILE_PERMISSIONS_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.changedFilePermissionOfDescription', {
  defaultMessage: 'changed file permissions of'
});
exports.CHANGED_FILE_PERMISSIONS_OF = CHANGED_FILE_PERMISSIONS_OF;
const CHANGED_FILE_OWNERSHIP_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.changeidleOwernshipOfDescription', {
  defaultMessage: 'changed file ownership of'
});
exports.CHANGED_FILE_OWNERSHIP_OF = CHANGED_FILE_OWNERSHIP_OF;
const LOADED_KERNEL_MODULE = _i18n.i18n.translate('xpack.securitySolution.auditd.loaedKernelModuleOfDescription', {
  defaultMessage: 'loaded kernel module of'
});
exports.LOADED_KERNEL_MODULE = LOADED_KERNEL_MODULE;
const UNLOADED_KERNEL_MODULE_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.unloadedKernelModuleOfDescription', {
  defaultMessage: 'unloaded kernel module of'
});
exports.UNLOADED_KERNEL_MODULE_OF = UNLOADED_KERNEL_MODULE_OF;
const CREATED_DIRECTORY = _i18n.i18n.translate('xpack.securitySolution.auditd.createdDirectoryDescription', {
  defaultMessage: 'created directory'
});
exports.CREATED_DIRECTORY = CREATED_DIRECTORY;
const MOUNTED = _i18n.i18n.translate('xpack.securitySolution.auditd.mountedDescription', {
  defaultMessage: 'mounted'
});
exports.MOUNTED = MOUNTED;
const RENAMED = _i18n.i18n.translate('xpack.securitySolution.auditd.renamedDescription', {
  defaultMessage: 'renamed'
});
exports.RENAMED = RENAMED;
const CHECKED_METADATA_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.chedckedMetaDataOfDescription', {
  defaultMessage: 'checked metadata of'
});
exports.CHECKED_METADATA_OF = CHECKED_METADATA_OF;
const CHECKED_FILE_SYSTEM_METADATA_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.checkedFileSystemMetadataOfDescription', {
  defaultMessage: 'checked filesystem metadata of'
});
exports.CHECKED_FILE_SYSTEM_METADATA_OF = CHECKED_FILE_SYSTEM_METADATA_OF;
const SYMLINKED = _i18n.i18n.translate('xpack.securitySolution.auditd.symLinkedDescription', {
  defaultMessage: 'symbolically linked'
});
exports.SYMLINKED = SYMLINKED;
const UNMOUNTED = _i18n.i18n.translate('xpack.securitySolution.auditd.unmountedDescription', {
  defaultMessage: 'unmounted'
});
exports.UNMOUNTED = UNMOUNTED;
const DELETED = _i18n.i18n.translate('xpack.securitySolution.auditd.deletedDescription', {
  defaultMessage: 'deleted'
});
exports.DELETED = DELETED;
const CHANGED_TIME_STAMP_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.changedTimeStampOfDescription', {
  defaultMessage: 'changed time stamp of'
});
exports.CHANGED_TIME_STAMP_OF = CHANGED_TIME_STAMP_OF;
const LISTEN_FOR_CONNECTIONS = _i18n.i18n.translate('xpack.securitySolution.auditd.ListeningForConnectionsUsingDescription', {
  defaultMessage: 'listening for connections using'
});
exports.LISTEN_FOR_CONNECTIONS = LISTEN_FOR_CONNECTIONS;
const BOUND_SOCKET_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.boundSocketFromDescription', {
  defaultMessage: 'bound socket from'
});
exports.BOUND_SOCKET_FROM = BOUND_SOCKET_FROM;
const RECEIVED_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.receivedFromDescription', {
  defaultMessage: 'received from'
});
exports.RECEIVED_FROM = RECEIVED_FROM;
const SENT_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.sentToDescription', {
  defaultMessage: 'sent to'
});
exports.SENT_TO = SENT_TO;
const KILLED_PROCESS_ID_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.killedProcessIdDescription', {
  defaultMessage: 'killed process id of'
});
exports.KILLED_PROCESS_ID_OF = KILLED_PROCESS_ID_OF;
const CHANGED_IDENTITY_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.changedIdentityUsingDescription', {
  defaultMessage: 'changed identity using'
});
exports.CHANGED_IDENTITY_USING = CHANGED_IDENTITY_USING;
const CHANGED_SYSTEM_TIME_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.changedSystemTimeWithDescription', {
  defaultMessage: 'changed system time with'
});
exports.CHANGED_SYSTEM_TIME_WITH = CHANGED_SYSTEM_TIME_WITH;
const MADE_DEVICE_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.madeDeviceWithDescription', {
  defaultMessage: 'made device with'
});
exports.MADE_DEVICE_WITH = MADE_DEVICE_WITH;
const CHANGED_SYSTEM_NAME = _i18n.i18n.translate('xpack.securitySolution.auditd.changedSystemNameDescription', {
  defaultMessage: 'changed system name'
});
exports.CHANGED_SYSTEM_NAME = CHANGED_SYSTEM_NAME;
const ALLOCATED_MEMORY_FOR = _i18n.i18n.translate('xpack.securitySolution.auditd.allocatedMemoryForDescription', {
  defaultMessage: 'allocated memory for'
});
exports.ALLOCATED_MEMORY_FOR = ALLOCATED_MEMORY_FOR;
const SCHEDULED_POLICY_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.scheduledPolicyOFDescription', {
  defaultMessage: 'scheduled policy of'
});
exports.SCHEDULED_POLICY_OF = SCHEDULED_POLICY_OF;
const ADDED_USER_ACCOUNT = _i18n.i18n.translate('xpack.securitySolution.auditd.addedUserAccountDescription', {
  defaultMessage: 'added user account'
});
exports.ADDED_USER_ACCOUNT = ADDED_USER_ACCOUNT;
const CAUSED_MAC_POLICY_ERROR = _i18n.i18n.translate('xpack.securitySolution.auditd.causedMacPolicyErrorDescription', {
  defaultMessage: 'caused mac policy error'
});
exports.CAUSED_MAC_POLICY_ERROR = CAUSED_MAC_POLICY_ERROR;
const LOADED_FIREWALL_RULE = _i18n.i18n.translate('xpack.securitySolution.auditd.loadedFirewallRuleDescription', {
  defaultMessage: 'loaded firewall rule'
});
exports.LOADED_FIREWALL_RULE = LOADED_FIREWALL_RULE;
const CHANGED_PROMISCUOUS_MODE = _i18n.i18n.translate('xpack.securitySolution.auditd.promiscuousModeDescription', {
  defaultMessage: 'changed promiscuous mode on the device using'
});
exports.CHANGED_PROMISCUOUS_MODE = CHANGED_PROMISCUOUS_MODE;
const LOCKED_ACCOUNT = _i18n.i18n.translate('xpack.securitySolution.auditd.lockedAccountDescription', {
  defaultMessage: 'locked account'
});
exports.LOCKED_ACCOUNT = LOCKED_ACCOUNT;
const UNLOCKED_ACCOUNT = _i18n.i18n.translate('xpack.securitySolution.auditd.unlockedAccountDescription', {
  defaultMessage: 'unlocked account'
});
exports.UNLOCKED_ACCOUNT = UNLOCKED_ACCOUNT;
const ADDED_GROUP_ACCOUNT_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.adddedGroupAccountUsingDescription', {
  defaultMessage: 'added group account using'
});
exports.ADDED_GROUP_ACCOUNT_USING = ADDED_GROUP_ACCOUNT_USING;
const CRASHED_PROGRAM = _i18n.i18n.translate('xpack.securitySolution.auditd.crashedProgramDescription', {
  defaultMessage: 'crashed program'
});
exports.CRASHED_PROGRAM = CRASHED_PROGRAM;
const EXECUTION_OF_FORBIDDEN_PROGRAM = _i18n.i18n.translate('xpack.securitySolution.auditd.executionOfForbiddenProgramDescription', {
  defaultMessage: 'execution of forbidden program'
});
exports.EXECUTION_OF_FORBIDDEN_PROGRAM = EXECUTION_OF_FORBIDDEN_PROGRAM;
const USED_SUSPICIOUS_PROGRAM = _i18n.i18n.translate('xpack.securitySolution.auditd.suspiciousProgramDescription', {
  defaultMessage: 'used suspicious program'
});
exports.USED_SUSPICIOUS_PROGRAM = USED_SUSPICIOUS_PROGRAM;
const FAILED_LOGIN_TOO_MANY_TIMES = _i18n.i18n.translate('xpack.securitySolution.auditd.failedLoginTooManyTimesDescription', {
  defaultMessage: 'failed login due to logging in too many times'
});
exports.FAILED_LOGIN_TOO_MANY_TIMES = FAILED_LOGIN_TOO_MANY_TIMES;
const ATTEMPTED_LOGIN_FROM_UNUSUAL_PLACE = _i18n.i18n.translate('xpack.securitySolution.auditd.attemptedLoginFromUnusalPlaceDescription', {
  defaultMessage: 'attempted login from unusual place'
});
exports.ATTEMPTED_LOGIN_FROM_UNUSUAL_PLACE = ATTEMPTED_LOGIN_FROM_UNUSUAL_PLACE;
const OPENED_TOO_MANY_SESSIONS = _i18n.i18n.translate('xpack.securitySolution.auditd.openedTooManySessionsDescription', {
  defaultMessage: 'opened too many sessions'
});
exports.OPENED_TOO_MANY_SESSIONS = OPENED_TOO_MANY_SESSIONS;
const ATTEMPTED_LOGIN_FROM_UNUSUAL_HOUR = _i18n.i18n.translate('xpack.securitySolution.auditd.attemptedLoginFromUnusualHourDescription', {
  defaultMessage: 'attempted login from unusual hour'
});
exports.ATTEMPTED_LOGIN_FROM_UNUSUAL_HOUR = ATTEMPTED_LOGIN_FROM_UNUSUAL_HOUR;
const TESTED_FILE_SYSTEM_INTEGRITY = _i18n.i18n.translate('xpack.securitySolution.auditd.testedFileSystemIntegrityDescription', {
  defaultMessage: 'tested file system integrity'
});
exports.TESTED_FILE_SYSTEM_INTEGRITY = TESTED_FILE_SYSTEM_INTEGRITY;
const VIOLATED_SELINUX_POLICY = _i18n.i18n.translate('xpack.securitySolution.auditd.violatedSeLinuxPolicyDescription', {
  defaultMessage: 'violated selinux policy'
});
exports.VIOLATED_SELINUX_POLICY = VIOLATED_SELINUX_POLICY;
const VIOLATED_APP_ARMOR_POLICY_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.violatedAppArmorPolicyFromDescription', {
  defaultMessage: 'violated app armor policy from'
});
exports.VIOLATED_APP_ARMOR_POLICY_FROM = VIOLATED_APP_ARMOR_POLICY_FROM;
const CHANGED_GROUP = _i18n.i18n.translate('xpack.securitySolution.auditd.changedGroupDescription', {
  defaultMessage: 'changed group'
});
exports.CHANGED_GROUP = CHANGED_GROUP;
const CHANGED_USER_ID = _i18n.i18n.translate('xpack.securitySolution.auditd.changedUserIdDescription', {
  defaultMessage: 'changed user id'
});
exports.CHANGED_USER_ID = CHANGED_USER_ID;
const CHANGED_AUDIT_CONFIGURATION = _i18n.i18n.translate('xpack.securitySolution.auditd.changedAuditConfigurationDescription', {
  defaultMessage: 'changed audit configuration'
});
exports.CHANGED_AUDIT_CONFIGURATION = CHANGED_AUDIT_CONFIGURATION;
const REFRESHED_CREDENTIALS_FOR = _i18n.i18n.translate('xpack.securitySolution.auditd.refreshedCredentialsForDescription', {
  defaultMessage: 'refreshed credentials for'
});
exports.REFRESHED_CREDENTIALS_FOR = REFRESHED_CREDENTIALS_FOR;
const NEGOTIATED_CRYPTO_KEY = _i18n.i18n.translate('xpack.securitySolution.auditd.negotiatedCryptoKeyDescription', {
  defaultMessage: 'negotiated crypto key'
});
exports.NEGOTIATED_CRYPTO_KEY = NEGOTIATED_CRYPTO_KEY;
const CRYPTO_OFFICER_LOGGED_IN = _i18n.i18n.translate('xpack.securitySolution.auditd.cryptoOfficerLoggedInDescription', {
  defaultMessage: 'crypto officer logged in'
});
exports.CRYPTO_OFFICER_LOGGED_IN = CRYPTO_OFFICER_LOGGED_IN;
const CRYPTO_OFFICER_LOGGED_OUT = _i18n.i18n.translate('xpack.securitySolution.auditd.cryptoOfficerLoggedOutDescription', {
  defaultMessage: 'crypto officer logged out'
});
exports.CRYPTO_OFFICER_LOGGED_OUT = CRYPTO_OFFICER_LOGGED_OUT;
const STARTED_CRYPTO_SESSION = _i18n.i18n.translate('xpack.securitySolution.auditd.startedCryptoSessionDescription', {
  defaultMessage: 'started crypto session'
});
exports.STARTED_CRYPTO_SESSION = STARTED_CRYPTO_SESSION;
const ACCESS_RESULT = _i18n.i18n.translate('xpack.securitySolution.auditd.accessResultDescription', {
  defaultMessage: 'access result'
});
exports.ACCESS_RESULT = ACCESS_RESULT;
const ABORTED_AUDIT_STARTUP = _i18n.i18n.translate('xpack.securitySolution.auditd.abortedAuditStartupDescription', {
  defaultMessage: 'aborted audit startup'
});
exports.ABORTED_AUDIT_STARTUP = ABORTED_AUDIT_STARTUP;
const REMOTE_AUDIT_CONNECTED = _i18n.i18n.translate('xpack.securitySolution.auditd.remoteAuditConnectedDescription', {
  defaultMessage: 'remote audit connected'
});
exports.REMOTE_AUDIT_CONNECTED = REMOTE_AUDIT_CONNECTED;
const REMOTE_AUDIT_DISCONNECTED = _i18n.i18n.translate('xpack.securitySolution.auditd.remoteAuditDisconnectedDescription', {
  defaultMessage: 'remote audit disconnected'
});
exports.REMOTE_AUDIT_DISCONNECTED = REMOTE_AUDIT_DISCONNECTED;
const SHUTDOWN_AUDIT = _i18n.i18n.translate('xpack.securitySolution.auditd.shutDownAuditDescription', {
  defaultMessage: 'shutdown audit'
});
exports.SHUTDOWN_AUDIT = SHUTDOWN_AUDIT;
const AUDIT_ERROR = _i18n.i18n.translate('xpack.securitySolution.auditd.auditErrorDescription', {
  defaultMessage: 'audit error'
});
exports.AUDIT_ERROR = AUDIT_ERROR;
const RECONFIGURED_AUDIT = _i18n.i18n.translate('xpack.securitySolution.auditd.reconfiguredAuditDescription', {
  defaultMessage: 'reconfigured audit'
});
exports.RECONFIGURED_AUDIT = RECONFIGURED_AUDIT;
const RESUMED_AUDIT_LOGGING = _i18n.i18n.translate('xpack.securitySolution.auditd.resumedAuditLoggingDescription', {
  defaultMessage: 'resumed audit logging'
});
exports.RESUMED_AUDIT_LOGGING = RESUMED_AUDIT_LOGGING;
const ROTATED_AUDIT_LOGS = _i18n.i18n.translate('xpack.securitySolution.auditd.rotatedAuditLogsDescription', {
  defaultMessage: 'rotated-audit-logs'
});
exports.ROTATED_AUDIT_LOGS = ROTATED_AUDIT_LOGS;
const STARTED_AUDIT = _i18n.i18n.translate('xpack.securitySolution.auditd.startedAuditDescription', {
  defaultMessage: 'started audit'
});
exports.STARTED_AUDIT = STARTED_AUDIT;
const DELETED_GROUP_ACCOUNT_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.deletedGroupAccountUsingDescription', {
  defaultMessage: 'deleted group account using'
});
exports.DELETED_GROUP_ACCOUNT_USING = DELETED_GROUP_ACCOUNT_USING;
const DELETED_USER_ACCOUNT_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.deletedUserAccountUsingDescription', {
  defaultMessage: 'deleted user account using'
});
exports.DELETED_USER_ACCOUNT_USING = DELETED_USER_ACCOUNT_USING;
const CHANGED_AUDIT_FEATURE = _i18n.i18n.translate('xpack.securitySolution.auditd.changedAuditFeatureDescription', {
  defaultMessage: 'changed audit feature'
});
exports.CHANGED_AUDIT_FEATURE = CHANGED_AUDIT_FEATURE;
const RELABELED_FILESYSTEM = _i18n.i18n.translate('xpack.securitySolution.auditd.relabeledFileSystemDescription', {
  defaultMessage: 'relabeled filesystem'
});
exports.RELABELED_FILESYSTEM = RELABELED_FILESYSTEM;
const AUTHENTICATED_TO_GROUP = _i18n.i18n.translate('xpack.securitySolution.auditd.authenticatedToGroupDescription', {
  defaultMessage: 'authenticated to group'
});
exports.AUTHENTICATED_TO_GROUP = AUTHENTICATED_TO_GROUP;
const CHANGED_GROUP_PASSWORD = _i18n.i18n.translate('xpack.securitySolution.auditd.changedGroupPasswordDescription', {
  defaultMessage: 'changed group password'
});
exports.CHANGED_GROUP_PASSWORD = CHANGED_GROUP_PASSWORD;
const MODIFIED_GROUP_ACCOUNT = _i18n.i18n.translate('xpack.securitySolution.auditd.modifiedGroupAccountDescription', {
  defaultMessage: 'modified group account'
});
exports.MODIFIED_GROUP_ACCOUNT = MODIFIED_GROUP_ACCOUNT;
const INITIALIZED_AUDIT_SUBSYSTEM = _i18n.i18n.translate('xpack.securitySolution.auditd.initializedAuditSubsystemDescription', {
  defaultMessage: 'initialized audit subsystem'
});
exports.INITIALIZED_AUDIT_SUBSYSTEM = INITIALIZED_AUDIT_SUBSYSTEM;
const MODIFIED_LEVEL_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.modifiedLevelOfDescription', {
  defaultMessage: 'modified level of'
});
exports.MODIFIED_LEVEL_OF = MODIFIED_LEVEL_OF;
const OVERRODE_LABEL_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.overrodeLabelOfDescription', {
  defaultMessage: 'overrode label of'
});
exports.OVERRODE_LABEL_OF = OVERRODE_LABEL_OF;
const CHANGED_LOGIN_ID_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.changedLoginIdToDescription', {
  defaultMessage: 'changed login id to'
});
exports.CHANGED_LOGIN_ID_TO = CHANGED_LOGIN_ID_TO;
const MAC_PERMISSION = _i18n.i18n.translate('xpack.securitySolution.auditd.macPermissionDescription', {
  defaultMessage: 'mac permission'
});
exports.MAC_PERMISSION = MAC_PERMISSION;
const CHANGED_SELINUX_BOOLEAN = _i18n.i18n.translate('xpack.securitySolution.auditd.changedSeLinuxBooleanDescription', {
  defaultMessage: 'changed selinux boolean'
});
exports.CHANGED_SELINUX_BOOLEAN = CHANGED_SELINUX_BOOLEAN;
const LOADED_SELINUX_POLICY = _i18n.i18n.translate('xpack.securitySolution.auditd.loadedSeLinuxPolicyDescription', {
  defaultMessage: 'loaded selinux policy'
});
exports.LOADED_SELINUX_POLICY = LOADED_SELINUX_POLICY;
const CHANGED_SELINUX_ENFORCEMENT = _i18n.i18n.translate('xpack.securitySolution.auditd.changedSelinuxEnforcementDescription', {
  defaultMessage: 'changed selinux enforcement'
});
exports.CHANGED_SELINUX_ENFORCEMENT = CHANGED_SELINUX_ENFORCEMENT;
const ASSIGNED_USER_ROLE_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.assignedUserRoleToDescription', {
  defaultMessage: 'assigned user role to'
});
exports.ASSIGNED_USER_ROLE_TO = ASSIGNED_USER_ROLE_TO;
const MODIFIED_ROLE = _i18n.i18n.translate('xpack.securitySolution.auditd.modifiedRoleDescription', {
  defaultMessage: 'modified role'
});
exports.MODIFIED_ROLE = MODIFIED_ROLE;
const REMOVED_USER_ROLE_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.removedUserRoleFromDescription', {
  defaultMessage: 'removed user role from'
});
exports.REMOVED_USER_ROLE_FROM = REMOVED_USER_ROLE_FROM;
const VIOLATED_SECCOMP_POLICY_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.violatedSeccompPolicyWithDescription', {
  defaultMessage: 'violated seccomp policy with'
});
exports.VIOLATED_SECCOMP_POLICY_WITH = VIOLATED_SECCOMP_POLICY_WITH;
const STARTED_SERVICE = _i18n.i18n.translate('xpack.securitySolution.auditd.startedServiceDescription', {
  defaultMessage: 'started service'
});
exports.STARTED_SERVICE = STARTED_SERVICE;
const STOPPED_SERVICE = _i18n.i18n.translate('xpack.securitySolution.auditd.stoppedServiceDescription', {
  defaultMessage: 'stopped service'
});
exports.STOPPED_SERVICE = STOPPED_SERVICE;
const BOOTED_SYSTEM = _i18n.i18n.translate('xpack.securitySolution.auditd.bootedSystemDescription', {
  defaultMessage: 'booted system'
});
exports.BOOTED_SYSTEM = BOOTED_SYSTEM;
const CHANGED_TO_RUN_LEVEL_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.changedToRunLevelWithDescription', {
  defaultMessage: 'changed to run level with'
});
exports.CHANGED_TO_RUN_LEVEL_WITH = CHANGED_TO_RUN_LEVEL_WITH;
const SHUTDOWN_SYSTEM = _i18n.i18n.translate('xpack.securitySolution.auditd.shutdownSystemDescription', {
  defaultMessage: 'shutdown system'
});
exports.SHUTDOWN_SYSTEM = SHUTDOWN_SYSTEM;
const SENT_TEST = _i18n.i18n.translate('xpack.securitySolution.auditd.sentTestDescription', {
  defaultMessage: 'sent test'
});
exports.SENT_TEST = SENT_TEST;
const UNKNOWN = _i18n.i18n.translate('xpack.securitySolution.auditd.unknownDescription', {
  defaultMessage: 'unknown'
});
exports.UNKNOWN = UNKNOWN;
const SENT_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.auditd.sentMessageDescription', {
  defaultMessage: 'sent message'
});
exports.SENT_MESSAGE = SENT_MESSAGE;
const ACCESS_PERMISSION = _i18n.i18n.translate('xpack.securitySolution.auditd.accessPermissionDescription', {
  defaultMessage: 'access permission'
});
exports.ACCESS_PERMISSION = ACCESS_PERMISSION;
const AUTHENTICATED_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.authenticatedUsingDescription', {
  defaultMessage: 'authenticated using'
});
exports.AUTHENTICATED_USING = AUTHENTICATED_USING;
const CHANGED_PASSWORD_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.changedPasswordWithDescription', {
  defaultMessage: 'changed password with'
});
exports.CHANGED_PASSWORD_WITH = CHANGED_PASSWORD_WITH;
const RAN_COMMAND = _i18n.i18n.translate('xpack.securitySolution.auditd.ranCommandDescription', {
  defaultMessage: 'ran command'
});
exports.RAN_COMMAND = RAN_COMMAND;
const ERROR_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.errorFromDescription', {
  defaultMessage: 'error from'
});
exports.ERROR_FROM = ERROR_FROM;
const LOGGED_OUT = _i18n.i18n.translate('xpack.securitySolution.auditd.loggedOutDescription', {
  defaultMessage: 'logged out'
});
exports.LOGGED_OUT = LOGGED_OUT;
const CHANGED_MAC_CONFIGURATION = _i18n.i18n.translate('xpack.securitySolution.auditd.changedMacConfigurationDescription', {
  defaultMessage: 'changed mac configuration'
});
exports.CHANGED_MAC_CONFIGURATION = CHANGED_MAC_CONFIGURATION;
const LOADED_MAC_POLICY = _i18n.i18n.translate('xpack.securitySolution.auditd.loadedMacPolicyDescription', {
  defaultMessage: 'loaded mac policy'
});
exports.LOADED_MAC_POLICY = LOADED_MAC_POLICY;
const MODIFIED_USER_ACCOUNT = _i18n.i18n.translate('xpack.securitySolution.auditd.modifiedUserAccountDescription', {
  defaultMessage: 'modified user account'
});
exports.MODIFIED_USER_ACCOUNT = MODIFIED_USER_ACCOUNT;
const CHANGED_ROLE_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.changedRoleUsingDescription', {
  defaultMessage: 'changed role using'
});
exports.CHANGED_ROLE_USING = CHANGED_ROLE_USING;
const ACCESS_ERROR = _i18n.i18n.translate('xpack.securitySolution.auditd.accessErrorDescription', {
  defaultMessage: 'access error'
});
exports.ACCESS_ERROR = ACCESS_ERROR;
const CHANGED_CONFIGURATION_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.changedConfigurationWIthDescription', {
  defaultMessage: 'changed configuration with'
});
exports.CHANGED_CONFIGURATION_WITH = CHANGED_CONFIGURATION_WITH;
const ISSUED_VM_CONTROL = _i18n.i18n.translate('xpack.securitySolution.auditd.issuedVmControlDescription', {
  defaultMessage: 'issued vm control'
});
exports.ISSUED_VM_CONTROL = ISSUED_VM_CONTROL;
const CREATED_VM_IMAGE = _i18n.i18n.translate('xpack.securitySolution.auditd.createdVmImageDescription', {
  defaultMessage: 'created vm image'
});
exports.CREATED_VM_IMAGE = CREATED_VM_IMAGE;
const DELETED_VM_IMAGE = _i18n.i18n.translate('xpack.securitySolution.auditd.deletedVmImageDescription', {
  defaultMessage: 'deleted vm image'
});
exports.DELETED_VM_IMAGE = DELETED_VM_IMAGE;
const CHECKED_INTEGRITY_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.checkedIntegrityOfDescription', {
  defaultMessage: 'checked integrity of'
});
exports.CHECKED_INTEGRITY_OF = CHECKED_INTEGRITY_OF;
const ASSIGNED_VM_ID = _i18n.i18n.translate('xpack.securitySolution.auditd.assignedVmIdDescription', {
  defaultMessage: 'assigned vm id'
});
exports.ASSIGNED_VM_ID = ASSIGNED_VM_ID;
const MIGRATED_VM_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.migratedVmFromDescription', {
  defaultMessage: 'migrated vm from'
});
exports.MIGRATED_VM_FROM = MIGRATED_VM_FROM;
const MIGRATED_VM_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.migratedVmToDescription', {
  defaultMessage: 'migrated vm to'
});
exports.MIGRATED_VM_TO = MIGRATED_VM_TO;
const ASSIGNED_VM_RESOURCE = _i18n.i18n.translate('xpack.securitySolution.auditd.assignedVMResourceDescription', {
  defaultMessage: 'assigned vm resource'
});
exports.ASSIGNED_VM_RESOURCE = ASSIGNED_VM_RESOURCE;