"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useManagedUser = void 0;
var _react = require("react");
var _use_installed_integrations = require("../../../../../detections/components/rules/related_integrations/use_installed_integrations");
var _search_strategy = require("../../../../../../common/search_strategy");
var _use_space_id = require("../../../../../common/hooks/use_space_id");
var _use_search_strategy = require("../../../../../common/containers/use_search_strategy");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _manage_query = require("../../../../../common/components/page/manage_query");
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const packages = [_constants.ENTRA_ID_PACKAGE_NAME, _constants.OKTA_PACKAGE_NAME];
const useManagedUser = (userName, observedUser) => {
  var _observedUser$details2;
  const {
    to,
    from,
    isInitializing,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  const {
    loading: loadingManagedUser,
    result: {
      users: managedUserData
    },
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.UsersQueries.managedDetails,
    initialResult: {
      users: {}
    },
    errorMessage: i18n.FAIL_MANAGED_USER
  });
  const defaultIndex = (0, _react.useMemo)(() => spaceId ? [(0, _constants.getEntraUserIndex)(spaceId), (0, _constants.getOktaUserIndex)(spaceId)] : [], [spaceId]);
  (0, _react.useEffect)(() => {
    if (!isInitializing && defaultIndex.length > 0 && !observedUser.isLoading && userName) {
      var _observedUser$details;
      search({
        defaultIndex,
        userEmail: (_observedUser$details = observedUser.details.user) === null || _observedUser$details === void 0 ? void 0 : _observedUser$details.email,
        userName
      });
    }
  }, [from, search, to, isInitializing, defaultIndex, userName, observedUser.isLoading, (_observedUser$details2 = observedUser.details.user) === null || _observedUser$details2 === void 0 ? void 0 : _observedUser$details2.email]);
  const {
    data: installedIntegrations,
    isLoading: loadingIntegrations
  } = (0, _use_installed_integrations.useInstalledIntegrations)({
    packages
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId: _constants.MANAGED_USER_QUERY_ID,
    loading: loadingManagedUser
  });
  const isIntegrationEnabled = (0, _react.useMemo)(() => !!(installedIntegrations !== null && installedIntegrations !== void 0 && installedIntegrations.some(({
    package_name: packageName,
    is_enabled: isEnabled
  }) => isEnabled && packages.includes(packageName))), [installedIntegrations]);
  return (0, _react.useMemo)(() => ({
    data: managedUserData,
    isLoading: loadingManagedUser || loadingIntegrations,
    isIntegrationEnabled
  }), [isIntegrationEnabled, loadingIntegrations, loadingManagedUser, managedUserData]);
};
exports.useManagedUser = useManagedUser;