"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutBody = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireDefault(require("react"));
var _host_isolation = require("../../../../../common/components/endpoint/host_isolation");
var _host_isolation2 = require("../../../../../detections/components/host_isolation");
var _expandable_event = require("../expandable_event");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflow {
    display: flex;
    flex: 1;
    overflow: hidden;

    .euiFlyoutBody__overflowContent {
      flex: 1;
      overflow: hidden;
      padding: ${({
  theme
}) => `0 ${theme.eui.euiSizeM} ${theme.eui.euiSizeM}`};
    }
  }
`;
const FlyoutBodyComponent = ({
  alertId,
  browserFields,
  detailsData,
  detailsEcsData,
  event,
  handleIsolationActionSuccess,
  handleOnEventClosed,
  hostName,
  isAlert,
  isDraggable,
  isReadOnly,
  isolateAction,
  isHostIsolationPanelOpen,
  isIsolateActionSuccessBannerVisible,
  loading,
  rawEventData,
  showAlertDetails,
  scopeId
}) => {
  return /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutBody, null, isIsolateActionSuccessBannerVisible && /*#__PURE__*/_react.default.createElement(_host_isolation.EndpointIsolateSuccess, {
    hostName: hostName,
    alertId: alertId,
    isolateAction: isolateAction
  }), isHostIsolationPanelOpen ? /*#__PURE__*/_react.default.createElement(_host_isolation2.HostIsolationPanel, {
    details: detailsData,
    cancelCallback: showAlertDetails,
    successCallback: handleIsolationActionSuccess,
    isolateAction: isolateAction
  }) : /*#__PURE__*/_react.default.createElement(_expandable_event.ExpandableEvent, {
    browserFields: browserFields,
    detailsData: detailsData,
    detailsEcsData: detailsEcsData,
    event: event,
    isAlert: isAlert,
    isDraggable: isDraggable,
    loading: loading,
    rawEventData: rawEventData,
    scopeId: scopeId,
    timelineTabType: "flyout",
    handleOnEventClosed: handleOnEventClosed,
    isReadOnly: isReadOnly
  }));
};
const FlyoutBody = /*#__PURE__*/_react.default.memo(FlyoutBodyComponent);
exports.FlyoutBody = FlyoutBody;