"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsRiskScores = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _enable_risk_score = require("../../../../explore/components/risk_score/enable_risk_score");
var _columns = require("./columns");
var _last_updated_at = require("../../../../common/components/last_updated_at");
var _header_section = require("../../../../common/components/header_section");
var _risk_score = require("../../../../explore/containers/risk_score");
var _search_strategy = require("../../../../../common/search_strategy");
var _helpers = require("../../../../explore/hosts/store/helpers");
var _manage_query = require("../../../../common/components/page/manage_query");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _inspect = require("../../../../common/components/inspect");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _styled_basic_table = require("../common/styled_basic_table");
var _risk_score_header_title = require("../../../../explore/components/risk_score/risk_score_onboarding/risk_score_header_title");
var _risk_score_no_data_detected = require("../../../../explore/components/risk_score/risk_score_onboarding/risk_score_no_data_detected");
var _use_refetch_queries = require("../../../../common/hooks/use_refetch_queries");
var _loader = require("../../../../common/components/loader");
var _panel = require("../../../../common/components/panel");
var _use_entity = require("./use_entity");
var _header_content = require("./header_content");
var _chart_content = require("./chart_content");
var _use_navigate_to_alerts_page_with_filters = require("../../../../common/hooks/use_navigate_to_alerts_page_with_filters");
var _translations = require("./translations");
var _kibana = require("../../../../common/lib/kibana");
var _use_global_filter_query = require("../../../../common/hooks/use_global_filter_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityAnalyticsRiskScoresComponent = ({
  riskEntity
}) => {
  const {
    deleteQuery,
    setQuery,
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const [updatedAt, setUpdatedAt] = (0, _react.useState)(Date.now());
  const entity = (0, _use_entity.useEntityInfo)(riskEntity);
  const openAlertsPageWithFilters = (0, _use_navigate_to_alerts_page_with_filters.useNavigateToAlertsPageWithFilters)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const openEntityOnAlertsPage = (0, _react.useCallback)(entityName => {
    telemetry.reportEntityAlertsClicked({
      entity: riskEntity
    });
    openAlertsPageWithFilters([{
      title: (0, _translations.getRiskEntityTranslation)(riskEntity),
      selectedOptions: [entityName],
      fieldName: riskEntity === _search_strategy.RiskScoreEntity.host ? 'host.name' : 'user.name'
    }]);
  }, [telemetry, riskEntity, openAlertsPageWithFilters]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(entity.tableQueryId);
  const columns = (0, _react.useMemo)(() => (0, _columns.getRiskScoreColumns)(riskEntity, openEntityOnAlertsPage), [riskEntity, openEntityOnAlertsPage]);
  const [selectedSeverity, setSelectedSeverity] = (0, _react.useState)([]);
  const onSelectSeverityFilterGroup = (0, _react.useCallback)(newSelection => {
    setSelectedSeverity(newSelection);
  }, []);
  const severityFilter = (0, _react.useMemo)(() => {
    const [filter] = (0, _helpers.generateSeverityFilter)(selectedSeverity, riskEntity);
    return filter ? filter : undefined;
  }, [riskEntity, selectedSeverity]);
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)({
    extraFilter: severityFilter
  });
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    severityCount,
    loading: isKpiLoading,
    refetch: refetchKpi,
    inspect: inspectKpi
  } = (0, _risk_score.useRiskScoreKpi)({
    filterQuery,
    skip: !toggleStatus,
    timerange,
    riskEntity
  });
  (0, _manage_query.useQueryInspector)({
    queryId: entity.kpiQueryId,
    loading: isKpiLoading,
    refetch: refetchKpi,
    setQuery,
    deleteQuery,
    inspect: inspectKpi
  });
  const {
    data,
    loading: isTableLoading,
    inspect,
    refetch,
    isDeprecated,
    isAuthorized,
    isModuleEnabled
  } = (0, _risk_score.useRiskScore)({
    filterQuery,
    skip: !toggleStatus,
    pagination: {
      cursorStart: 0,
      querySize: 5
    },
    timerange,
    riskEntity,
    includeAlertsCount: true
  });
  (0, _manage_query.useQueryInspector)({
    queryId: entity.tableQueryId,
    loading: isTableLoading,
    refetch,
    setQuery,
    deleteQuery,
    inspect
  });
  (0, _react.useEffect)(() => {
    setUpdatedAt(Date.now());
  }, [isTableLoading, isKpiLoading]); // Update the time when data loads

  const refreshPage = (0, _use_refetch_queries.useRefetchQueries)();
  if (!isAuthorized) {
    return null;
  }
  const status = {
    isDisabled: !isModuleEnabled && !isTableLoading,
    isDeprecated: isDeprecated && !isTableLoading
  };
  if (status.isDisabled || status.isDeprecated) {
    return /*#__PURE__*/_react.default.createElement(_enable_risk_score.EnableRiskScore, (0, _extends2.default)({}, status, {
      entityType: riskEntity,
      refetch: refreshPage,
      timerange: timerange
    }));
  }
  if (isModuleEnabled && selectedSeverity.length === 0 && data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_risk_score_no_data_detected.RiskScoresNoDataDetected, {
      entityType: riskEntity,
      refetch: refreshPage
    });
  }
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    hasBorder: true,
    "data-test-subj": `entity_analytics_${riskEntity}s`
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      riskScoreEntity: riskEntity
    }),
    titleSize: "s",
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      isUpdating: isTableLoading || isKpiLoading,
      updatedAt: updatedAt
    }),
    id: entity.tableQueryId,
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus
  }, /*#__PURE__*/_react.default.createElement(_header_content.RiskScoreHeaderContent, {
    entityLinkProps: entity.linkProps,
    onSelectSeverityFilterGroup: onSelectSeverityFilterGroup,
    riskEntity: riskEntity,
    selectedSeverity: selectedSeverity,
    severityCount: severityCount,
    toggleStatus: toggleStatus
  })), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "entity_analytics_content"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chart_content.ChartContent, {
    dataExists: data && data.length > 0,
    kpiQueryId: entity.kpiQueryId,
    riskEntity: riskEntity,
    severityCount: severityCount,
    timerange: timerange,
    selectedSeverity: selectedSeverity
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_styled_basic_table.StyledBasicTable, {
    responsive: false,
    items: data !== null && data !== void 0 ? data : [],
    columns: columns,
    loading: isTableLoading,
    id: entity.tableQueryId,
    rowProps: {
      className: 'EntityAnalyticsTableHoverActions'
    }
  }))), (isTableLoading || isKpiLoading) && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    "data-test-subj": "loadingPanelRiskScore",
    overlay: true,
    size: "xl"
  })));
};
const EntityAnalyticsRiskScores = /*#__PURE__*/_react.default.memo(EntityAnalyticsRiskScoresComponent);
exports.EntityAnalyticsRiskScores = EntityAnalyticsRiskScores;
EntityAnalyticsRiskScores.displayName = 'EntityAnalyticsRiskScores';