"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserAlertsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _cellActions = require("@kbn/cell-actions");
var _constants = require("../../../../actions/constants");
var _use_navigate_to_alerts_page_with_filters = require("../../../../common/hooks/use_navigate_to_alerts_page_with_filters");
var _formatted_number = require("../../../../common/components/formatted_number");
var _header_section = require("../../../../common/components/header_section");
var _hover_visibility_container = require("../../../../common/components/hover_visibility_container");
var _inspect = require("../../../../common/components/inspect");
var _last_updated_at = require("../../../../common/components/last_updated_at");
var _links = require("../../../../common/components/links");
var _query_toggle = require("../../../../common/containers/query_toggle");
var i18n = _interopRequireWildcard(require("../translations"));
var _utils = require("../utils");
var _use_user_alerts_items = require("./use_user_alerts_items");
var _cell_actions = require("../../../../common/components/cell_actions");
var _use_global_filter_query = require("../../../../common/hooks/use_global_filter_query");
var _model = require("../../../../common/store/sourcerer/model");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETECTION_RESPONSE_USER_SEVERITY_QUERY_ID = 'vulnerableUsersBySeverityQuery';
const UserAlertsTable = /*#__PURE__*/_react.default.memo(({
  signalIndexName
}) => {
  const openAlertsPageWithFilters = (0, _use_navigate_to_alerts_page_with_filters.useNavigateToAlertsPageWithFilters)();
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const openUserInAlerts = (0, _react.useCallback)(({
    userName,
    severity
  }) => openAlertsPageWithFilters([{
    title: i18n.OPEN_IN_ALERTS_TITLE_USERNAME,
    selectedOptions: [userName],
    fieldName: 'user.name'
  }, ...(severity ? [{
    title: i18n.OPEN_IN_ALERTS_TITLE_SEVERITY,
    selectedOptions: [severity],
    fieldName: _ruleDataUtils.ALERT_SEVERITY
  }] : [])]), [openAlertsPageWithFilters]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTION_RESPONSE_USER_SEVERITY_QUERY_ID);
  const {
    items,
    isLoading,
    updatedAt,
    pagination
  } = (0, _use_user_alerts_items.useUserAlertsItems)({
    skip: !toggleStatus,
    queryId: DETECTION_RESPONSE_USER_SEVERITY_QUERY_ID,
    signalIndexName,
    filterQuery
  });
  const columns = (0, _react.useMemo)(() => getTableColumns(openUserInAlerts), [openUserInAlerts]);
  return /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: true,
    targetClassNames: [_inspect.BUTTON_CLASS]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "severityUserAlertsPanel"
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: DETECTION_RESPONSE_USER_SEVERITY_QUERY_ID,
    title: i18n.USER_ALERTS_SECTION_TITLE,
    titleSize: "s",
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      updatedAt: updatedAt,
      isUpdating: isLoading
    }),
    tooltip: i18n.USER_TOOLTIP
  }), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "severityUserAlertsTable",
    columns: columns,
    items: items,
    loading: isLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.NO_ALERTS_FOUND),
      titleSize: "xs"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), pagination.pageCount > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    "data-test-subj": "userTablePaginator",
    activePage: pagination.currentPage,
    itemsPerPage: _utils.ITEMS_PER_PAGE,
    pageCount: pagination.pageCount,
    onChangePage: pagination.setPage,
    showPerPageOptions: false
  }))));
});
exports.UserAlertsTable = UserAlertsTable;
UserAlertsTable.displayName = 'UserAlertsTable';
const getTableColumns = handleClick => [{
  field: 'userName',
  name: i18n.USER_ALERTS_USERNAME_COLUMN,
  'data-test-subj': 'userSeverityAlertsTable-userName',
  render: userName => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: i18n.OPEN_USER_DETAIL_TOOLTIP,
    content: userName,
    anchorClassName: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
    userName: userName
  }))
}, {
  field: 'totalAlerts',
  name: i18n.ALERTS_TEXT,
  'data-test-subj': 'userSeverityAlertsTable-totalAlerts',
  render: (totalAlerts, {
    userName
  }) => /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: {
      value: userName,
      field: 'user.name'
    },
    mode: _cellActions.CellActionsMode.HOVER_RIGHT,
    triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
    sourcererScopeId: _model.SourcererScopeName.detections,
    metadata: {
      andFilters: [{
        field: 'kibana.alert.workflow_status',
        value: 'open'
      }]
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "userSeverityAlertsTable-totalAlertsLink",
    disabled: totalAlerts === 0,
    onClick: () => handleClick({
      userName
    })
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: totalAlerts
  })))
}, {
  field: 'critical',
  name: i18n.STATUS_CRITICAL_LABEL,
  render: (count, {
    userName
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": "userSeverityAlertsTable-critical",
    color: _utils.SEVERITY_COLOR.critical
  }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: {
      value: userName,
      field: 'user.name'
    },
    mode: _cellActions.CellActionsMode.HOVER_RIGHT,
    triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
    sourcererScopeId: _model.SourcererScopeName.detections,
    metadata: {
      andFilters: [{
        field: 'kibana.alert.severity',
        value: 'critical'
      }, {
        field: 'kibana.alert.workflow_status',
        value: 'open'
      }]
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "userSeverityAlertsTable-criticalLink",
    onClick: () => handleClick({
      userName,
      severity: 'critical'
    })
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  }))
}, {
  field: 'high',
  name: i18n.STATUS_HIGH_LABEL,
  render: (count, {
    userName
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": "userSeverityAlertsTable-high",
    color: _utils.SEVERITY_COLOR.high
  }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: {
      value: userName,
      field: 'user.name'
    },
    mode: _cellActions.CellActionsMode.HOVER_RIGHT,
    triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
    sourcererScopeId: _model.SourcererScopeName.detections,
    metadata: {
      andFilters: [{
        field: 'kibana.alert.severity',
        value: 'high'
      }, {
        field: 'kibana.alert.workflow_status',
        value: 'open'
      }]
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => handleClick({
      userName,
      severity: 'high'
    })
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  }))
}, {
  field: 'medium',
  name: i18n.STATUS_MEDIUM_LABEL,
  render: (count, {
    userName
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": "userSeverityAlertsTable-medium",
    color: _utils.SEVERITY_COLOR.medium
  }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: {
      value: userName,
      field: 'user.name'
    },
    mode: _cellActions.CellActionsMode.HOVER_RIGHT,
    triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
    sourcererScopeId: _model.SourcererScopeName.detections,
    metadata: {
      andFilters: [{
        field: 'kibana.alert.severity',
        value: 'medium'
      }, {
        field: 'kibana.alert.workflow_status',
        value: 'open'
      }]
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => handleClick({
      userName,
      severity: 'medium'
    })
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  }))
}, {
  field: 'low',
  name: i18n.STATUS_LOW_LABEL,
  render: (count, {
    userName
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": "userSeverityAlertsTable-low",
    color: _utils.SEVERITY_COLOR.low
  }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: {
      value: userName,
      field: 'user.name'
    },
    mode: _cellActions.CellActionsMode.HOVER_RIGHT,
    triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
    sourcererScopeId: _model.SourcererScopeName.detections,
    metadata: {
      andFilters: [{
        field: 'kibana.alert.severity',
        value: 'low'
      }, {
        field: 'kibana.alert.workflow_status',
        value: 'open'
      }]
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => handleClick({
      userName,
      severity: 'low'
    })
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  }))
}];