"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_RECENT_CASES = exports.VIEW_CASES = exports.USER_TOOLTIP = exports.USER_ALERTS_USERNAME_COLUMN = exports.USER_ALERTS_SECTION_TITLE = exports.UPDATING = exports.UPDATED = exports.STATUS_OPEN = exports.STATUS_MEDIUM_LABEL = exports.STATUS_LOW_LABEL = exports.STATUS_IN_PROGRESS = exports.STATUS_HIGH_LABEL = exports.STATUS_CRITICAL_LABEL = exports.STATUS_CLOSED = exports.STATUS_ACKNOWLEDGED = exports.RULE_ALERTS_SECTION_TITLE = exports.RULE_ALERTS_COLUMN_SEVERITY = exports.RULE_ALERTS_COLUMN_RULE_NAME = exports.RULE_ALERTS_COLUMN_LAST_ALERT = exports.RULE_ALERTS_COLUMN_ALERT_COUNT = exports.OPEN_USER_DETAIL_TOOLTIP = exports.OPEN_RULE_DETAIL_TOOLTIP = exports.OPEN_IN_ALERTS_TITLE_USERNAME = exports.OPEN_IN_ALERTS_TITLE_STATUS = exports.OPEN_IN_ALERTS_TITLE_SEVERITY = exports.OPEN_IN_ALERTS_TITLE_RULENAME = exports.OPEN_IN_ALERTS_TITLE_HOSTNAME = exports.OPEN_HOST_DETAIL_TOOLTIP = exports.OPEN_CASE_DETAIL_TOOLTIP = exports.OPEN_ALL_ALERTS_BUTTON = exports.NO_CASES_FOUND = exports.NO_ALERTS_FOUND = exports.INVESTIGATE_IN_TIMELINE = exports.HOST_TOOLTIP = exports.HOST_ALERTS_SECTION_TITLE = exports.HOST_ALERTS_HOSTNAME_COLUMN = exports.ERROR_MESSAGE_CASES = exports.CASES_TABLE_SECTION_TOOLTIP = exports.CASES_TABLE_SECTION_TITLE = exports.CASES_TABLE_COLUMN_TIME = exports.CASES_TABLE_COLUMN_STATUS = exports.CASES_TABLE_COLUMN_NAME = exports.CASES_TABLE_COLUMN_CREATED_BY = exports.CASES_BY_STATUS_SECTION_TOOLTIP = exports.CASES_BY_STATUS_SECTION_TITLE = exports.CASES = exports.ALERTS_TEXT = exports.ALERTS_BY_SEVERITY_TEXT = exports.ALERTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_CRITICAL_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.alertsByStatus.donut.criticalLabel', {
  defaultMessage: 'Critical'
});
exports.STATUS_CRITICAL_LABEL = STATUS_CRITICAL_LABEL;
const STATUS_HIGH_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.alertsByStatus.donut.highLabel', {
  defaultMessage: 'High'
});
exports.STATUS_HIGH_LABEL = STATUS_HIGH_LABEL;
const STATUS_MEDIUM_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.alertsByStatus.donut.mediumLabel', {
  defaultMessage: 'Medium'
});
exports.STATUS_MEDIUM_LABEL = STATUS_MEDIUM_LABEL;
const STATUS_LOW_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.alertsByStatus.donut.lowLabel', {
  defaultMessage: 'Low'
});
exports.STATUS_LOW_LABEL = STATUS_LOW_LABEL;
const STATUS_ACKNOWLEDGED = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.alertsByStatus.status.acknowledged', {
  defaultMessage: 'Acknowledged'
});
exports.STATUS_ACKNOWLEDGED = STATUS_ACKNOWLEDGED;
const STATUS_OPEN = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.status.open', {
  defaultMessage: 'Open'
});
exports.STATUS_OPEN = STATUS_OPEN;
const STATUS_CLOSED = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.status.closed', {
  defaultMessage: 'Closed'
});
exports.STATUS_CLOSED = STATUS_CLOSED;
const STATUS_IN_PROGRESS = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.status.inProgress', {
  defaultMessage: 'In progress'
});
exports.STATUS_IN_PROGRESS = STATUS_IN_PROGRESS;
const ALERTS = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.detectionResponse.alertsByStatus.totalAlerts', {
  values: {
    totalAlerts
  },
  defaultMessage: 'total {totalAlerts, plural, =1 {alert} other {alerts}}'
});
exports.ALERTS = ALERTS;
const ALERTS_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.alerts', {
  defaultMessage: 'Alerts'
});
exports.ALERTS_TEXT = ALERTS_TEXT;
const ALERTS_BY_SEVERITY_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.alertsBySeverity', {
  defaultMessage: 'Alerts by Severity'
});
exports.ALERTS_BY_SEVERITY_TEXT = ALERTS_BY_SEVERITY_TEXT;
const UPDATING = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.updating', {
  defaultMessage: 'Updating...'
});
exports.UPDATING = UPDATING;
const UPDATED = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.updated', {
  defaultMessage: 'Updated'
});
exports.UPDATED = UPDATED;
const CASES = totalCases => _i18n.i18n.translate('xpack.securitySolution.detectionResponse.casesByStatus.totalCases', {
  values: {
    totalCases
  },
  defaultMessage: 'total {totalCases, plural, =1 {case} other {cases}}'
});
exports.CASES = CASES;
const CASES_BY_STATUS_SECTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.casesByStatusSectionTitle', {
  defaultMessage: 'Cases'
});
exports.CASES_BY_STATUS_SECTION_TITLE = CASES_BY_STATUS_SECTION_TITLE;
const CASES_BY_STATUS_SECTION_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.casesByStatusSectionTooltip', {
  defaultMessage: 'The cases table is not filterable via the SIEM global KQL search.'
});
exports.CASES_BY_STATUS_SECTION_TOOLTIP = CASES_BY_STATUS_SECTION_TOOLTIP;
const VIEW_CASES = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.viewCases', {
  defaultMessage: 'View cases'
});
exports.VIEW_CASES = VIEW_CASES;
const RULE_ALERTS_SECTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.ruleAlertsSectionTitle', {
  defaultMessage: 'Open alerts by rule'
});
exports.RULE_ALERTS_SECTION_TITLE = RULE_ALERTS_SECTION_TITLE;
const HOST_ALERTS_SECTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.hostAlertsSectionTitle', {
  defaultMessage: 'Hosts by alert severity'
});
exports.HOST_ALERTS_SECTION_TITLE = HOST_ALERTS_SECTION_TITLE;
const USER_ALERTS_SECTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.userAlertsSectionTitle', {
  defaultMessage: 'Users by alert severity'
});
exports.USER_ALERTS_SECTION_TITLE = USER_ALERTS_SECTION_TITLE;
const CASES_TABLE_SECTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.caseSectionTitle', {
  defaultMessage: 'Recently created cases'
});
exports.CASES_TABLE_SECTION_TITLE = CASES_TABLE_SECTION_TITLE;
const CASES_TABLE_SECTION_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.caseSectionTooltip', {
  defaultMessage: 'The recently created cases table is not filterable via the SIEM global KQL search.'
});
exports.CASES_TABLE_SECTION_TOOLTIP = CASES_TABLE_SECTION_TOOLTIP;
const NO_ALERTS_FOUND = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.noRuleAlerts', {
  defaultMessage: 'No alerts to display'
});
exports.NO_ALERTS_FOUND = NO_ALERTS_FOUND;
const NO_CASES_FOUND = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.noRecentCases', {
  defaultMessage: 'No cases to display'
});
exports.NO_CASES_FOUND = NO_CASES_FOUND;
const RULE_ALERTS_COLUMN_RULE_NAME = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.ruleAlertsColumnRuleName', {
  defaultMessage: 'Rule name'
});
exports.RULE_ALERTS_COLUMN_RULE_NAME = RULE_ALERTS_COLUMN_RULE_NAME;
const RULE_ALERTS_COLUMN_LAST_ALERT = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.ruleAlertsColumnLastAlert', {
  defaultMessage: 'Last alert'
});
exports.RULE_ALERTS_COLUMN_LAST_ALERT = RULE_ALERTS_COLUMN_LAST_ALERT;
const RULE_ALERTS_COLUMN_ALERT_COUNT = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.ruleAlertsColumnAlertCount', {
  defaultMessage: 'Alert count'
});
exports.RULE_ALERTS_COLUMN_ALERT_COUNT = RULE_ALERTS_COLUMN_ALERT_COUNT;
const RULE_ALERTS_COLUMN_SEVERITY = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.ruleAlertsColumnSeverity', {
  defaultMessage: 'Severity'
});
exports.RULE_ALERTS_COLUMN_SEVERITY = RULE_ALERTS_COLUMN_SEVERITY;
const OPEN_RULE_DETAIL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.openRuleDetailTooltip', {
  defaultMessage: 'Open rule detail'
});
exports.OPEN_RULE_DETAIL_TOOLTIP = OPEN_RULE_DETAIL_TOOLTIP;
const OPEN_CASE_DETAIL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.openCaseDetailTooltip', {
  defaultMessage: 'Open case detail'
});
exports.OPEN_CASE_DETAIL_TOOLTIP = OPEN_CASE_DETAIL_TOOLTIP;
const OPEN_HOST_DETAIL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.openHostDetailTooltip', {
  defaultMessage: 'Open host detail'
});
exports.OPEN_HOST_DETAIL_TOOLTIP = OPEN_HOST_DETAIL_TOOLTIP;
const OPEN_USER_DETAIL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.openUserDetailTooltip', {
  defaultMessage: 'Open user detail'
});
exports.OPEN_USER_DETAIL_TOOLTIP = OPEN_USER_DETAIL_TOOLTIP;
const OPEN_ALL_ALERTS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.openAllAlertsButton', {
  defaultMessage: 'View all open alerts'
});
exports.OPEN_ALL_ALERTS_BUTTON = OPEN_ALL_ALERTS_BUTTON;
const VIEW_RECENT_CASES = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.viewRecentCases', {
  defaultMessage: 'View recent cases'
});
exports.VIEW_RECENT_CASES = VIEW_RECENT_CASES;
const HOST_ALERTS_HOSTNAME_COLUMN = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.hostAlertsHostName', {
  defaultMessage: 'Host name'
});
exports.HOST_ALERTS_HOSTNAME_COLUMN = HOST_ALERTS_HOSTNAME_COLUMN;
const USER_ALERTS_USERNAME_COLUMN = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.userAlertsUserName', {
  defaultMessage: 'User name'
});
exports.USER_ALERTS_USERNAME_COLUMN = USER_ALERTS_USERNAME_COLUMN;
const CASES_TABLE_COLUMN_NAME = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.caseColumnName', {
  defaultMessage: 'Name'
});
exports.CASES_TABLE_COLUMN_NAME = CASES_TABLE_COLUMN_NAME;
const CASES_TABLE_COLUMN_TIME = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.caseColumnTime', {
  defaultMessage: 'Time'
});
exports.CASES_TABLE_COLUMN_TIME = CASES_TABLE_COLUMN_TIME;
const CASES_TABLE_COLUMN_CREATED_BY = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.caseColumnCreatedBy', {
  defaultMessage: 'Created by'
});
exports.CASES_TABLE_COLUMN_CREATED_BY = CASES_TABLE_COLUMN_CREATED_BY;
const CASES_TABLE_COLUMN_STATUS = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.caseColumnStatus', {
  defaultMessage: 'Status'
});
exports.CASES_TABLE_COLUMN_STATUS = CASES_TABLE_COLUMN_STATUS;
const ERROR_MESSAGE_CASES = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.errorMessage', {
  defaultMessage: 'Error fetching case data'
});
exports.ERROR_MESSAGE_CASES = ERROR_MESSAGE_CASES;
const HOST_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.hostSectionTooltip', {
  defaultMessage: 'Maximum of 100 hosts. Please consult Alerts page for further information.'
});
exports.HOST_TOOLTIP = HOST_TOOLTIP;
const USER_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.userSectionTooltip', {
  defaultMessage: 'Maximum of 100 users. Please consult Alerts page for further information.'
});
exports.USER_TOOLTIP = USER_TOOLTIP;
const INVESTIGATE_IN_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.investigateInTimeline', {
  defaultMessage: 'Investigate in Timeline'
});
exports.INVESTIGATE_IN_TIMELINE = INVESTIGATE_IN_TIMELINE;
const OPEN_IN_ALERTS_TITLE_SEVERITY = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.openInAlertsSeverity', {
  defaultMessage: 'Severity'
});
exports.OPEN_IN_ALERTS_TITLE_SEVERITY = OPEN_IN_ALERTS_TITLE_SEVERITY;
const OPEN_IN_ALERTS_TITLE_STATUS = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.openInAlertsStatus', {
  defaultMessage: 'Status'
});
exports.OPEN_IN_ALERTS_TITLE_STATUS = OPEN_IN_ALERTS_TITLE_STATUS;
const OPEN_IN_ALERTS_TITLE_RULENAME = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.openInAlertsRuleName', {
  defaultMessage: 'Rule name'
});
exports.OPEN_IN_ALERTS_TITLE_RULENAME = OPEN_IN_ALERTS_TITLE_RULENAME;
const OPEN_IN_ALERTS_TITLE_HOSTNAME = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.openInAlertsHostName', {
  defaultMessage: 'Host name'
});
exports.OPEN_IN_ALERTS_TITLE_HOSTNAME = OPEN_IN_ALERTS_TITLE_HOSTNAME;
const OPEN_IN_ALERTS_TITLE_USERNAME = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.openInAlertsUserName', {
  defaultMessage: 'Username'
});
exports.OPEN_IN_ALERTS_TITLE_USERNAME = OPEN_IN_ALERTS_TITLE_USERNAME;