"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdministrationSubTab = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * The type for the management store global namespace. Used mostly internally to reference
 * the type while defining more complex interfaces/types
 */
/**
 * The management list of sub-tabs. Changes to these will impact the Router routes.
 */
let AdministrationSubTab;
/**
 * The URL route params for the Management Policy List section
 */
exports.AdministrationSubTab = AdministrationSubTab;
(function (AdministrationSubTab) {
  AdministrationSubTab["endpoints"] = "endpoints";
  AdministrationSubTab["policies"] = "policy";
  AdministrationSubTab["trustedApps"] = "trusted_apps";
  AdministrationSubTab["eventFilters"] = "event_filters";
  AdministrationSubTab["hostIsolationExceptions"] = "host_isolation_exceptions";
  AdministrationSubTab["blocklist"] = "blocklist";
  AdministrationSubTab["responseActionsHistory"] = "response_actions_history";
  AdministrationSubTab["protectionUpdates"] = "protection_updates";
})(AdministrationSubTab || (exports.AdministrationSubTab = AdministrationSubTab = {}));
/**
 * The URL route params for the Management Policy Details section
 */