"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.managementMiddlewareFactory = void 0;
var _store = require("../../common/store");
var _constants = require("../common/constants");
var _policy_details = require("../pages/policy/store/policy_details");
var _middleware = require("../pages/endpoint_hosts/store/middleware");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSubStateSelector = namespace => state => state[_constants.MANAGEMENT_STORE_GLOBAL_NAMESPACE][namespace];
const managementMiddlewareFactory = (coreStart, depsStart) => {
  return [(0, _store.substateMiddlewareFactory)(createSubStateSelector(_constants.MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE), (0, _policy_details.policyDetailsMiddlewareFactory)(coreStart, depsStart)), (0, _store.substateMiddlewareFactory)(createSubStateSelector(_constants.MANAGEMENT_STORE_ENDPOINTS_NAMESPACE), (0, _middleware.endpointMiddlewareFactory)(coreStart, depsStart))];
};
exports.managementMiddlewareFactory = managementMiddlewareFactory;