"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../../../../app/translations");
var _administration_list_page = require("../../../components/administration_list_page");
var _response_actions_log = require("../../../components/endpoint_response_actions_list/response_actions_log");
var _translations2 = require("../../../components/endpoint_response_actions_list/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponseActionsListPage = () => {
  const [hideHeader, setHideHeader] = (0, _react.useState)(true);
  const resetPageHeader = (0, _react.useCallback)(isData => {
    setHideHeader(!isData);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_administration_list_page.AdministrationListPage, {
    "data-test-subj": "responseActionsPage",
    title: _translations.RESPONSE_ACTIONS_HISTORY,
    subtitle: _translations2.UX_MESSAGES.pageSubTitle,
    hideHeader: hideHeader
  }, /*#__PURE__*/_react.default.createElement(_response_actions_log.ResponseActionsLog, {
    showHostNames: true,
    isFlyout: false,
    setIsDataInResponse: resetPageHeader
  }));
};
exports.ResponseActionsListPage = ResponseActionsListPage;
ResponseActionsListPage.displayName = 'ResponseActionsListPage';