"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingCardHeader = exports.SettingCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = require("styled-components");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _translations = require("../../../../../common/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TITLES = {
  type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailType', {
    defaultMessage: 'Type'
  }),
  os: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailOS', {
    defaultMessage: 'Operating system'
  })
};
const SettingCardHeader = /*#__PURE__*/(0, _react.memo)(({
  children,
  'data-test-subj': dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxs",
  "data-test-subj": dataTestSubj
}, /*#__PURE__*/_react.default.createElement("h5", null, children)));
exports.SettingCardHeader = SettingCardHeader;
SettingCardHeader.displayName = 'SettingCardHeader';
const SettingCard = /*#__PURE__*/(0, _react.memo)(({
  type,
  supportedOss,
  osRestriction,
  dataTestSubj,
  rightCorner,
  children,
  selected = true,
  mode = 'edit'
}) => {
  const paddingSize = (0, _react.useContext)(_styledComponents.ThemeContext).eui.euiPanelPaddingModifiers.paddingMedium;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": getTestId(),
    hasBorder: true,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    alignItems: "center",
    style: {
      padding: `${paddingSize} ${paddingSize} 0 ${paddingSize}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(SettingCardHeader, null, TITLES.type), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": getTestId('type')
  }, type)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(SettingCardHeader, null, TITLES.os), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    "data-test-subj": getTestId('osValueContainer')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": getTestId('osValues')
  }, supportedOss.map(os => _translations.OS_TITLES[os]).join(', '), ' ')), osRestriction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('osRestriction')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.antivirusRegistration.osRestriction",
    defaultMessage: "Restrictions"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "warning",
    color: "warning",
    content: osRestriction,
    anchorProps: {
      'data-test-subj': getTestId('osRestrictionTooltipIcon')
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['m', 'l', 'xl']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('rightCornerContainer')
  }, rightCorner)))), /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: rightCorner ? ['s', 'xs'] : []
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": getTestId('rightCornerContainer')
  }, rightCorner))), mode === 'edit' || selected ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: `0 ${paddingSize} ${paddingSize} ${paddingSize}`
    }
  }, children)) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
});
exports.SettingCard = SettingCard;
SettingCard.displayName = 'SettingCard';