"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectionSettingCardSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _use_license = require("../../../../../../common/hooks/use_license");
var _types = require("../../../../../../../common/endpoint/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProtectionSettingCardSwitch = /*#__PURE__*/_react.default.memo(({
  protection,
  protectionLabel,
  osList,
  additionalOnSwitchChange,
  onChange,
  policy,
  mode,
  selected,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const isEditMode = mode === 'edit';
  const switchLabel = (0, _react.useMemo)(() => {
    return _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.protectionsEnabled', {
      defaultMessage: '{protectionLabel} {mode, select, true {enabled} false {disabled}}',
      values: {
        protectionLabel,
        mode: selected
      }
    });
  }, [protectionLabel, selected]);
  const handleSwitchChange = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    if (event.target.checked === false) {
      for (const os of osList) {
        if (os === 'windows') {
          newPayload[os][protection].mode = _types.ProtectionModes.off;
        } else if (os === 'mac') {
          newPayload[os][protection].mode = _types.ProtectionModes.off;
        } else if (os === 'linux') {
          newPayload[os][protection].mode = _types.ProtectionModes.off;
        }
        if (isPlatinumPlus) {
          if (os === 'windows') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          } else if (os === 'mac') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          } else if (os === 'linux') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          }
          if (protection === 'behavior_protection') {
            newPayload.windows.behavior_protection.reputation_service = false;
            newPayload.mac.behavior_protection.reputation_service = false;
            newPayload.linux.behavior_protection.reputation_service = false;
          }
        }
      }
    } else {
      for (const os of osList) {
        if (os === 'windows') {
          newPayload[os][protection].mode = _types.ProtectionModes.prevent;
        } else if (os === 'mac') {
          newPayload[os][protection].mode = _types.ProtectionModes.prevent;
        } else if (os === 'linux') {
          newPayload[os][protection].mode = _types.ProtectionModes.prevent;
        }
        if (isPlatinumPlus) {
          if (protection === 'behavior_protection') {
            newPayload.windows.behavior_protection.reputation_service = true;
            newPayload.mac.behavior_protection.reputation_service = true;
            newPayload.linux.behavior_protection.reputation_service = true;
          }
          if (os === 'windows') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          } else if (os === 'mac') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          } else if (os === 'linux') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          }
        }
      }
    }
    onChange({
      isValid: true,
      updatedPolicy: additionalOnSwitchChange ? additionalOnSwitchChange({
        value: event.target.checked,
        policyConfigData: newPayload,
        protectionOsList: osList
      }) : newPayload
    });
  }, [policy, onChange, additionalOnSwitchChange, osList, isPlatinumPlus, protection]);
  if (!isEditMode) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": getTestId()
    }, switchLabel);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: switchLabel,
    labelProps: {
      'data-test-subj': getTestId('label')
    },
    checked: selected,
    onChange: handleSwitchChange,
    "data-test-subj": getTestId()
  });
});
exports.ProtectionSettingCardSwitch = ProtectionSettingCardSwitch;
ProtectionSettingCardSwitch.displayName = 'ProtectionSettingCardSwitch';