"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WindowsEventCollectionCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _event_collection_card = require("../event_collection_card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPTIONS = [{
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.windows.events.credentialAccess', {
    defaultMessage: 'API'
  }),
  protectionField: 'credential_access'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.windows.events.dllDriverLoad', {
    defaultMessage: 'DLL and Driver Load'
  }),
  protectionField: 'dll_and_driver_load'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.windows.events.dns', {
    defaultMessage: 'DNS'
  }),
  protectionField: 'dns'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.windows.events.file', {
    defaultMessage: 'File'
  }),
  protectionField: 'file'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.windows.events.network', {
    defaultMessage: 'Network'
  }),
  protectionField: 'network'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.windows.events.process', {
    defaultMessage: 'Process'
  }),
  protectionField: 'process'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.windows.events.registry', {
    defaultMessage: 'Registry'
  }),
  protectionField: 'registry'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.windows.events.security', {
    defaultMessage: 'Security'
  }),
  protectionField: 'security'
}];
const WindowsEventCollectionCard = /*#__PURE__*/(0, _react.memo)(props => {
  return /*#__PURE__*/_react.default.createElement(_event_collection_card.EventCollectionCard, (0, _extends2.default)({}, props, {
    os: _securitysolutionUtils.OperatingSystem.WINDOWS,
    selection: props.policy.windows.events,
    options: OPTIONS
  }));
});
exports.WindowsEventCollectionCard = WindowsEventCollectionCard;
WindowsEventCollectionCard.displayName = 'WindowsEventCollectionCard';