"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALUE_LABEL_HELPER = exports.VALUE_LABEL = exports.SELECT_OS_LABEL = exports.POLICY_SELECT_DESCRIPTION = exports.OPERATOR_LABEL = exports.NAME_LABEL = exports.FIELD_LABEL = exports.ERRORS = exports.DETAILS_HEADER_DESCRIPTION = exports.DETAILS_HEADER = exports.DESCRIPTION_LABEL = exports.CONDITION_FIELD_TITLE = exports.CONDITION_FIELD_DESCRIPTION = exports.CONDITIONS_HEADER_DESCRIPTION = exports.CONDITIONS_HEADER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETAILS_HEADER = _i18n.i18n.translate('xpack.securitySolution.blocklist.details.header', {
  defaultMessage: 'Details'
});
exports.DETAILS_HEADER = DETAILS_HEADER;
const DETAILS_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.blocklist.details.header.description', {
  defaultMessage: 'The blocklist prevents selected applications from running on your hosts by extending the list of processes the Endpoint considers malicious.'
});
exports.DETAILS_HEADER_DESCRIPTION = DETAILS_HEADER_DESCRIPTION;
const NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.blocklist.name.label', {
  defaultMessage: 'Name'
});
exports.NAME_LABEL = NAME_LABEL;
const DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.blocklist.description.label', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION_LABEL = DESCRIPTION_LABEL;
const CONDITIONS_HEADER = _i18n.i18n.translate('xpack.securitySolution.blocklist.conditions.header', {
  defaultMessage: 'Conditions'
});
exports.CONDITIONS_HEADER = CONDITIONS_HEADER;
const CONDITIONS_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.blocklist.conditions.header.description', {
  defaultMessage: 'Select an operating system and add conditions. Availability of conditions may depend on your chosen OS.'
});
exports.CONDITIONS_HEADER_DESCRIPTION = CONDITIONS_HEADER_DESCRIPTION;
const SELECT_OS_LABEL = _i18n.i18n.translate('xpack.securitySolution.blocklist.os.label', {
  defaultMessage: 'Select operating system'
});
exports.SELECT_OS_LABEL = SELECT_OS_LABEL;
const FIELD_LABEL = _i18n.i18n.translate('xpack.securitySolution.blocklist.field.label', {
  defaultMessage: 'Field'
});
exports.FIELD_LABEL = FIELD_LABEL;
const OPERATOR_LABEL = _i18n.i18n.translate('xpack.securitySolution.blocklist.operator.label', {
  defaultMessage: 'Operator'
});
exports.OPERATOR_LABEL = OPERATOR_LABEL;
const VALUE_LABEL = _i18n.i18n.translate('xpack.securitySolution.blocklist.value.label', {
  defaultMessage: 'Value'
});
exports.VALUE_LABEL = VALUE_LABEL;
const VALUE_LABEL_HELPER = _i18n.i18n.translate('xpack.securitySolution.blocklist.value.label.helper', {
  defaultMessage: 'Type or copy & paste one or multiple comma delimited values'
});
exports.VALUE_LABEL_HELPER = VALUE_LABEL_HELPER;
const CONDITION_FIELD_TITLE = {
  'file.hash.*': _i18n.i18n.translate('xpack.securitySolution.blocklist.entry.field.hash', {
    defaultMessage: 'Hash'
  }),
  'file.path': _i18n.i18n.translate('xpack.securitySolution.blocklist.entry.field.path', {
    defaultMessage: 'Path'
  }),
  'file.path.caseless': _i18n.i18n.translate('xpack.securitySolution.blocklist.entry.field.path.caseless', {
    defaultMessage: 'Path'
  }),
  'file.Ext.code_signature': _i18n.i18n.translate('xpack.securitySolution.blocklist.entry.field.signature', {
    defaultMessage: 'Signature'
  })
};
exports.CONDITION_FIELD_TITLE = CONDITION_FIELD_TITLE;
const CONDITION_FIELD_DESCRIPTION = {
  'file.hash.*': _i18n.i18n.translate('xpack.securitySolution.blocklist.entry.field.description.hash', {
    defaultMessage: 'md5, sha1, or sha256'
  }),
  'file.path': _i18n.i18n.translate('xpack.securitySolution.blocklist.entry.field.description.path', {
    defaultMessage: 'The full path of the application'
  }),
  'file.path.caseless': _i18n.i18n.translate('xpack.securitySolution.blocklist.entry.field.description.path.caseless', {
    defaultMessage: 'The full path of the application (case insenstive)'
  }),
  'file.Ext.code_signature': _i18n.i18n.translate('xpack.securitySolution.blocklist.entry.field.description.signature', {
    defaultMessage: 'The signer of the application'
  })
};
exports.CONDITION_FIELD_DESCRIPTION = CONDITION_FIELD_DESCRIPTION;
const POLICY_SELECT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.blocklist.policyAssignmentSectionDescription', {
  defaultMessage: 'Assign this blocklist globally across all policies, or assign it to specific policies.'
});
exports.POLICY_SELECT_DESCRIPTION = POLICY_SELECT_DESCRIPTION;
const ERRORS = {
  NAME_REQUIRED: _i18n.i18n.translate('xpack.securitySolution.blocklist.errors.name.required', {
    defaultMessage: 'Name is required'
  }),
  VALUE_REQUIRED: _i18n.i18n.translate('xpack.securitySolution.blocklist.errors.values.required', {
    defaultMessage: 'Field entry must have a value'
  }),
  INVALID_HASH: _i18n.i18n.translate('xpack.securitySolution.blocklist.errors.values.invalidHash', {
    defaultMessage: 'Invalid hash value'
  }),
  INVALID_PATH: _i18n.i18n.translate('xpack.securitySolution.blocklist.warnings.values.invalidPath', {
    defaultMessage: 'Path may be formed incorrectly; verify value'
  }),
  WILDCARD_PRESENT: _i18n.i18n.translate('xpack.securitySolution.blocklist.warnings.values.wildcardPresent', {
    defaultMessage: "A wildcard in the filename will affect the endpoint's performance"
  }),
  DUPLICATE_VALUE: _i18n.i18n.translate('xpack.securitySolution.blocklist.warnings.values.duplicateValue', {
    defaultMessage: 'This value already exists'
  }),
  DUPLICATE_VALUES: _i18n.i18n.translate('xpack.securitySolution.blocklist.warnings.values.duplicateValues', {
    defaultMessage: 'One or more duplicate values removed'
  })
};
exports.ERRORS = ERRORS;