"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActionHistoryUrlParams = exports.actionsLogFiltersFromUrlParams = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../../../common/endpoint/service/response_actions/constants");
var _use_url_params = require("../../../hooks/use_url_params");
var _hooks = require("./hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionsLogFiltersFromUrlParams = urlParams => {
  const actionsLogFilters = {
    commands: [],
    hosts: [],
    statuses: [],
    startDate: _hooks.DEFAULT_DATE_RANGE_OPTIONS.startDate,
    endDate: _hooks.DEFAULT_DATE_RANGE_OPTIONS.endDate,
    users: [],
    withOutputs: [],
    types: []
  };
  const urlCommands = urlParams.commands ? String(urlParams.commands).split(',').reduce((acc, curr) => {
    if (_constants.RESPONSE_ACTION_API_COMMANDS_NAMES.includes(curr) || curr === 'release' || curr === 'processes') {
      acc.push(curr);
    }
    return acc.sort();
  }, []) : [];
  const urlHosts = urlParams.hosts ? String(urlParams.hosts).split(',').sort() : [];
  const urlTypes = urlParams.types ? String(urlParams.types).split(',').sort() : [];
  const urlWithOutputs = urlParams.withOutputs ? String(urlParams.withOutputs).split(',').sort() : [];
  const urlStatuses = urlParams.statuses ? String(urlParams.statuses).split(',').reduce((acc, curr) => {
    if (_constants.RESPONSE_ACTION_STATUS.includes(curr)) {
      acc.push(curr);
    }
    return acc.sort();
  }, []) : [];
  const urlUsers = urlParams.users ? String(urlParams.users).split(',').sort() : [];
  actionsLogFilters.commands = urlCommands.length ? urlCommands : undefined;
  actionsLogFilters.hosts = urlHosts.length ? urlHosts : undefined;
  actionsLogFilters.statuses = urlStatuses.length ? urlStatuses : undefined;
  actionsLogFilters.startDate = urlParams.startDate ? String(urlParams.startDate) : undefined;
  actionsLogFilters.endDate = urlParams.endDate ? String(urlParams.endDate) : undefined;
  actionsLogFilters.users = urlUsers.length ? urlUsers : undefined;
  actionsLogFilters.withOutputs = urlWithOutputs.length ? urlWithOutputs : undefined;
  actionsLogFilters.types = urlTypes.length ? urlTypes : undefined;
  return actionsLogFilters;
};
exports.actionsLogFiltersFromUrlParams = actionsLogFiltersFromUrlParams;
const useActionHistoryUrlParams = () => {
  // track actions and status filters
  const location = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    urlParams,
    toUrlParams
  } = (0, _use_url_params.useUrlParams)();
  const getUrlActionsLogFilters = (0, _react.useMemo)(() => actionsLogFiltersFromUrlParams(urlParams), [urlParams]);
  const [actionsLogFilters, setActionsLogFilters] = (0, _react.useState)(getUrlActionsLogFilters);
  const setUrlActionsFilters = (0, _react.useCallback)(commands => {
    history.push({
      ...location,
      search: toUrlParams({
        ...urlParams,
        commands: commands.length ? commands : undefined
      })
    });
  }, [history, location, toUrlParams, urlParams]);
  const setUrlHostsFilters = (0, _react.useCallback)(agentIds => {
    history.push({
      ...location,
      search: toUrlParams({
        ...urlParams,
        hosts: agentIds.length ? agentIds : undefined
      })
    });
  }, [history, location, toUrlParams, urlParams]);
  const setUrlWithOutputs = (0, _react.useCallback)(actionIds => {
    history.push({
      ...location,
      search: toUrlParams({
        ...urlParams,
        withOutputs: actionIds.length ? actionIds : undefined
      })
    });
  }, [history, location, toUrlParams, urlParams]);
  const setUrlStatusesFilters = (0, _react.useCallback)(statuses => {
    history.push({
      ...location,
      search: toUrlParams({
        ...urlParams,
        statuses: statuses.length ? statuses : undefined
      })
    });
  }, [history, location, toUrlParams, urlParams]);
  const setUrlTypeFilters = (0, _react.useCallback)(types => {
    history.push({
      ...location,
      search: toUrlParams({
        ...urlParams,
        types: types.length ? types : undefined
      })
    });
  }, [history, location, toUrlParams, urlParams]);
  const setUrlUsersFilters = (0, _react.useCallback)(users => {
    history.push({
      ...location,
      search: toUrlParams({
        ...urlParams,
        users: users.length ? users : undefined
      })
    });
  }, [history, location, toUrlParams, urlParams]);
  const setUrlDateRangeFilters = (0, _react.useCallback)(({
    startDate,
    endDate
  }) => {
    history.push({
      ...location,
      search: toUrlParams({
        ...urlParams,
        startDate: startDate.length ? startDate : undefined,
        endDate: endDate.length ? endDate : undefined
      })
    });
  }, [history, location, toUrlParams, urlParams]);
  (0, _react.useEffect)(() => {
    setActionsLogFilters(prevState => {
      return {
        ...prevState,
        ...actionsLogFiltersFromUrlParams(urlParams)
      };
    });
  }, [setActionsLogFilters, urlParams]);
  return {
    ...actionsLogFilters,
    setUrlActionsFilters,
    setUrlDateRangeFilters,
    setUrlHostsFilters,
    setUrlWithOutputs,
    setUrlStatusesFilters,
    setUrlUsersFilters,
    setUrlTypeFilters
  };
};
exports.useActionHistoryUrlParams = useActionHistoryUrlParams;