"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogFilter = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _actions_log_filter_popover = require("./actions_log_filter_popover");
var _hooks = require("./hooks");
var _clear_all_button = require("./clear_all_button");
var _translations = require("../translations");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionsLogFilter = /*#__PURE__*/(0, _react.memo)(({
  filterName,
  isFlyout,
  onChangeFilterOptions,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);

  // popover states and handlers
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onPopoverButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [setIsPopoverOpen, isPopoverOpen]);
  const onClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);

  // search string state
  const [searchString, setSearchString] = (0, _react.useState)('');
  const {
    areHostsSelectedOnMount,
    isLoading,
    items,
    setItems,
    hasActiveFilters,
    numActiveFilters,
    numFilters,
    setAreHostsSelectedOnMount,
    setUrlActionsFilters,
    setUrlHostsFilters,
    setUrlStatusesFilters,
    setUrlTypeFilters
  } = (0, _hooks.useActionsLogFilter)({
    filterName,
    isFlyout,
    isPopoverOpen,
    searchString
  });

  // track popover state to pin selected options
  const wasPopoverOpen = (0, _react.useRef)(isPopoverOpen);
  (0, _react.useEffect)(() => {
    return () => {
      wasPopoverOpen.current = isPopoverOpen;
    };
  }, [isPopoverOpen, wasPopoverOpen]);

  // compute if selected hosts should be pinned
  const shouldPinSelectedHosts = (0, _react.useCallback)((isNotChangingOptions = true) => {
    // case 1: when no hosts are selected initially
    return isNotChangingOptions && wasPopoverOpen.current && isPopoverOpen && filterName === 'hosts';
  }, [filterName, isPopoverOpen]);

  // augmented options based on hosts filter
  const sortedHostsFilterOptions = (0, _react.useMemo)(() => {
    if (shouldPinSelectedHosts() || areHostsSelectedOnMount) {
      // pin checked items to the top
      return (0, _fp.orderBy)('checked', 'asc', items);
    }
    // return options as is for other filters
    return items;
  }, [areHostsSelectedOnMount, shouldPinSelectedHosts, items]);
  const isSearchable = (0, _react.useMemo)(() => filterName !== 'statuses' && filterName !== 'type', [filterName]);
  const onOptionsChange = (0, _react.useCallback)(newOptions => {
    // update filter UI options state
    setItems(newOptions.map(option => option));

    // compute selected list of options
    const selectedItems = newOptions.reduce((acc, curr) => {
      if (curr.checked === 'on') {
        acc.push(curr.key);
      }
      return acc;
    }, []);
    if (!isFlyout) {
      // update URL params
      if (filterName === 'actions') {
        setUrlActionsFilters(selectedItems.map(item => (0, _hooks.getUiCommand)(item)).join());
      } else if (filterName === 'hosts') {
        setUrlHostsFilters(selectedItems.join());
      } else if (filterName === 'statuses') {
        setUrlStatusesFilters(selectedItems.join());
      } else if (filterName === 'type') {
        setUrlTypeFilters(selectedItems.join());
      }
      // reset shouldPinSelectedHosts, setAreHostsSelectedOnMount
      shouldPinSelectedHosts(false);
      setAreHostsSelectedOnMount(false);
    }

    // update query state
    onChangeFilterOptions(selectedItems);
  }, [setItems, isFlyout, onChangeFilterOptions, filterName, shouldPinSelectedHosts, setAreHostsSelectedOnMount, setUrlActionsFilters, setUrlHostsFilters, setUrlStatusesFilters, setUrlTypeFilters]);

  // clear all selected options
  const onClearAll = (0, _react.useCallback)(() => {
    // update filter UI options state
    setItems(items.map(option => {
      option.checked = undefined;
      return option;
    }));
    if (!isFlyout) {
      // update URL params based on filter
      if (filterName === 'actions') {
        setUrlActionsFilters('');
      } else if (filterName === 'hosts') {
        setUrlHostsFilters('');
      } else if (filterName === 'statuses') {
        setUrlStatusesFilters('');
      } else if (filterName === 'type') {
        setUrlTypeFilters('');
      }
    }
    // update query state
    onChangeFilterOptions([]);
  }, [setItems, items, isFlyout, onChangeFilterOptions, filterName, setUrlActionsFilters, setUrlHostsFilters, setUrlStatusesFilters, setUrlTypeFilters]);
  return /*#__PURE__*/_react.default.createElement(_actions_log_filter_popover.ActionsLogFilterPopover, {
    closePopover: onClosePopover,
    filterName: filterName,
    hasActiveFilters: hasActiveFilters,
    isPopoverOpen: isPopoverOpen,
    numActiveFilters: numActiveFilters,
    numFilters: numFilters,
    onButtonClick: onPopoverButtonClick,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": `${filterName}`,
    emptyMessage: _translations.UX_MESSAGES.filterEmptyMessage(filterName),
    isLoading: isLoading,
    onChange: onOptionsChange,
    options: sortedHostsFilterOptions,
    searchable: isSearchable ? true : undefined,
    searchProps: {
      placeholder: _translations.UX_MESSAGES.filterSearchPlaceholder(filterName),
      compressed: true,
      onChange: searchValue => setSearchString(searchValue.trim())
    }
  }, (list, search) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: 300
      },
      "data-test-subj": getTestId(`${filterName}-filter-popoverList`)
    }, isSearchable && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      "data-test-subj": getTestId(`${filterName}-filter-search`),
      paddingSize: "s"
    }, search), list, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_clear_all_button.ClearAllButton, {
      "data-test-subj": getTestId(`${filterName}-filter-clearAllButton`),
      isDisabled: !hasActiveFilters,
      onClick: onClearAll
    }))));
  }));
});
exports.ActionsLogFilter = ActionsLogFilter;
ActionsLogFilter.displayName = 'ActionsLogFilter';