"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointActionFailureMessage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _endpoint_action_response_codes = require("../endpoint_responder/lib/endpoint_action_response_codes");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointActionFailureMessage = /*#__PURE__*/(0, _react.memo)(({
  action,
  'data-test-subj': dataTestSubj
}) => {
  return (0, _react.useMemo)(() => {
    if (!action.isCompleted || action.wasSuccessful) {
      return null;
    }
    const errors = [];

    // Determine if each endpoint returned a response code and if so,
    // see if we have a localized message for it
    if (action.outputs) {
      for (const agent of action.agents) {
        const endpointAgentOutput = action.outputs[agent];
        if (endpointAgentOutput && endpointAgentOutput.type === 'json' && endpointAgentOutput.content.code && _endpoint_action_response_codes.endpointActionResponseCodes[endpointAgentOutput.content.code]) {
          errors.push(_endpoint_action_response_codes.endpointActionResponseCodes[endpointAgentOutput.content.code]);
        }
      }
    }
    if (!errors.length) {
      if (action.errors) {
        errors.push(...action.errors);
      } else {
        errors.push(_i18n.i18n.translate('xpack.securitySolution.endpointActionFailureMessage.unknownFailure', {
          defaultMessage: 'Action failed'
        }));
      }
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": dataTestSubj
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpointResponseActions.actionError.errorMessage",
      defaultMessage: "The following { errorCount, plural, =1 {error was} other {errors were}} encountered:",
      values: {
        errorCount: errors.length
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("div", null, errors.join(' | ')));
  }, [action.agents, action.errors, action.isCompleted, action.outputs, action.wasSuccessful, dataTestSubj]);
});
exports.EndpointActionFailureMessage = EndpointActionFailureMessage;
EndpointActionFailureMessage.displayName = 'EndpointActionFailureMessage';