"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidePanelFlexItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _side_panel_content_manager = require("./side_panel_content_manager");
var _use_with_side_panel = require("../../hooks/state_selectors/use_with_side_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlexItemWhite = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  background-color: ${({
  theme: {
    eui
  }
}) => eui.euiColorEmptyShade} !important;
  border-radius: ${({
  theme: {
    eui
  }
}) => `0 ${eui.euiSizeXS} ${eui.euiSizeXS} 0`};
  box-shadow: 0 ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS} ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS}
    ${({
  theme: {
    eui
  }
}) => (0, _eui.transparentize)(eui.euiShadowColor, 0.04)};
`;
const SidePanelFlexItem = /*#__PURE__*/(0, _react.memo)(props => {
  const isPanelOpened = Boolean((0, _use_with_side_panel.useWithSidePanel)().show);
  if (!isPanelOpened) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(StyledEuiFlexItemWhite, {
    grow: false,
    className: "layout-rightPanel"
  }, /*#__PURE__*/_react.default.createElement(_side_panel_content_manager.SidePanelContentManager, null));
});
exports.SidePanelFlexItem = SidePanelFlexItem;
SidePanelFlexItem.displayName = 'SidePanelFlexItem';