"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionFlyoutContextProvider = exports.SecuritySolutionFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _isolate_host = require("./document_details/isolate_host");
var _context = require("./document_details/isolate_host/context");
var _right = require("./document_details/right");
var _context2 = require("./document_details/right/context");
var _left = require("./document_details/left");
var _context3 = require("./document_details/left/context");
var _preview = require("./document_details/preview");
var _context4 = require("./document_details/preview/context");
var _user_right = require("./entity_details/user_right");
var _risk_inputs_left = require("./entity_details/risk_inputs_left");
var _asset_document_left = require("./entity_details/asset_document_left");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * List of all panels that will be used within the document details expandable flyout.
 * This needs to be passed to the expandable flyout registeredPanels property.
 */
const expandableFlyoutDocumentsPanels = [{
  key: _right.DocumentDetailsRightPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context2.RightPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_right.RightPanel, {
    path: props.path
  }))
}, {
  key: _asset_document_left.AssetDocumentLeftPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context2.RightPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_asset_document_left.AssetDocumentLeftPanel, props))
}, {
  key: _left.DocumentDetailsLeftPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context3.LeftPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_left.LeftPanel, {
    path: props.path
  }))
}, {
  key: _preview.DocumentDetailsPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context4.PreviewPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_preview.PreviewPanel, {
    path: props.path
  }))
}, {
  key: _isolate_host.DocumentDetailsIsolateHostPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context.IsolateHostPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_isolate_host.IsolateHostPanel, {
    path: props.path
  }))
}, {
  key: _user_right.UserPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_user_right.UserPanel, props.params)
}, {
  key: _risk_inputs_left.RiskInputsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_risk_inputs_left.RiskInputsPanel, props.params)
}];

// NOTE: provider below accepts "storage" prop, please take a look into component's JSDoc.
const SecuritySolutionFlyoutContextProvider = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyoutProvider, {
  storage: "url"
}, children);
exports.SecuritySolutionFlyoutContextProvider = SecuritySolutionFlyoutContextProvider;
SecuritySolutionFlyoutContextProvider.displayName = 'SecuritySolutionFlyoutContextProvider';
const SecuritySolutionFlyout = /*#__PURE__*/(0, _react.memo)(() => /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyout, {
  registeredPanels: expandableFlyoutDocumentsPanels,
  paddingSize: "none"
}));
exports.SecuritySolutionFlyout = SecuritySolutionFlyout;
SecuritySolutionFlyout.displayName = 'SecuritySolutionFlyout';