"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskInputActions = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _react = require("react");
var _fp = require("lodash/fp");
var _common = require("@kbn/cases-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _model = require("../../../../common/store/sourcerer/model");
var _use_add_bulk_to_timeline = require("../../../../detections/components/alerts_table/timeline_actions/use_add_bulk_to_timeline");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The returned actions only support alerts risk inputs.
 */
const useRiskInputActions = (alerts, closePopover) => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const timelineAction = (0, _use_add_bulk_to_timeline.useAddBulkToTimelineAction)({
    localFilters: [],
    from,
    to,
    scopeId: _model.SourcererScopeName.detections,
    tableId: _securitysolutionDataTable.TableId.riskInputs
  });
  const {
    cases: casesService
  } = (0, _kibana_react.useKibana)().services;
  const createCaseFlyout = casesService === null || casesService === void 0 ? void 0 : casesService.hooks.useCasesAddToNewCaseFlyout({
    onSuccess: _fp.noop
  });
  const selectCaseModal = casesService === null || casesService === void 0 ? void 0 : casesService.hooks.useCasesAddToExistingCaseModal();
  const caseAttachments = (0, _react.useMemo)(() => alerts.map(alert => ({
    alertId: alert._id,
    index: alert._index,
    type: _common.AttachmentType.alert,
    rule: {
      id: (0, _fp.get)(_ruleDataUtils.ALERT_RULE_UUID, alert.fields)[0],
      name: (0, _fp.get)(_ruleDataUtils.ALERT_RULE_NAME, alert.fields)[0]
    }
  })), [alerts]);
  return (0, _react.useMemo)(() => ({
    addToExistingCase: () => {
      closePopover();
      selectCaseModal.open({
        getAttachments: () => caseAttachments
      });
    },
    addToNewCaseClick: () => {
      closePopover();
      createCaseFlyout.open({
        attachments: caseAttachments
      });
    },
    addToNewTimeline: () => {
      closePopover();
      timelineAction.onClick(alerts.map(alert => {
        return {
          _id: alert._id,
          _index: alert._index,
          data: [],
          ecs: {
            _id: alert._id,
            _index: alert._index
          }
        };
      }), false, _fp.noop, _fp.noop, _fp.noop);
    }
  }), [alerts, caseAttachments, closePopover, createCaseFlyout, selectCaseModal, timelineAction]);
};
exports.useRiskInputActions = useRiskInputActions;