"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskInputsPanelContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _action_column = require("./components/action_column");
var _formatted_date = require("../../../common/components/formatted_date");
var _utility_bar = require("./components/utility_bar");
var _use_alerts_by_ids = require("../../../common/containers/alerts/use_alerts_by_ids");
var _flyout_body = require("../../shared/components/flyout_body");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskInputsPanelContent = ({
  riskInputs
}) => {
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const alertIds = (0, _react.useMemo)(() => riskInputs.map(({
    id
  }) => id), [riskInputs]);
  const {
    loading,
    data: alertsData
  } = (0, _use_alerts_by_ids.useAlertsByIds)({
    alertIds
  });
  const euiTableSelectionProps = (0, _react.useMemo)(() => ({
    onSelectionChange: selected => {
      setSelectedItems(selected);
    },
    initialSelected: [],
    selectable: () => true
  }), []);
  const columns = (0, _react.useMemo)(() => [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.actionsColumn",
      defaultMessage: "Actions"
    }),
    width: '80px',
    render: alert => {
      return /*#__PURE__*/_react.default.createElement(_action_column.ActionColumn, {
        alert: alert
      });
    }
  }, {
    field: 'fields.@timestamp',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.dateColumn",
      defaultMessage: "Date"
    }),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    width: '30%',
    render: timestamp => /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(timestamp)
    })
  }, {
    field: 'fields',
    'data-test-subj': 'risk-input-table-description-cell',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.riskInputColumn",
      defaultMessage: "Risk input"
    }),
    truncateText: true,
    mobileOptions: {
      show: true
    },
    sortable: true,
    render: fields => (0, _fp.get)(_ruleDataUtils.ALERT_RULE_NAME, fields)
  }], []);
  const [currentPage, setCurrentPage] = (0, _react.useState)({
    index: 0,
    size: 10
  });
  const onTableChange = (0, _react.useCallback)(({
    page
  }) => {
    setCurrentPage(page);
  }, []);
  const pagination = (0, _react.useMemo)(() => ({
    totalItemCount: riskInputs.length,
    pageIndex: currentPage.index,
    pageSize: currentPage.size
  }), [currentPage.index, currentPage.size, riskInputs.length]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
    css: (0, _react2.css)`
          background-color: ${(0, _eui.useEuiBackgroundColor)('subdued')};
        `,
    "data-test-subj": "risk-inputs-panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.title",
    defaultMessage: "Risk Inputs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.alertsTitle",
    defaultMessage: "Alerts"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_utility_bar.RiskInputsUtilityBar, {
    pagination: pagination,
    selectedAlerts: selectedItems
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    compressed: true,
    loading: loading,
    items: alertsData !== null && alertsData !== void 0 ? alertsData : [],
    columns: columns,
    pagination: true,
    sorting: true,
    selection: euiTableSelectionProps,
    onTableChange: onTableChange,
    isSelectable: true,
    itemId: "_id"
  })));
};
exports.RiskInputsPanelContent = RiskInputsPanelContent;
RiskInputsPanelContent.displayName = 'RiskInputsPanelContent';