"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEventDetails = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _use_route_spy = require("../../../../common/utils/route/use_route_spy");
var _model = require("../../../../common/store/sourcerer/model");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _details = require("../../../../timelines/containers/details");
var _use_get_fields_data = require("../../../../common/hooks/use_get_fields_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to retrieve event details for alert details flyout contexts
 */
const useEventDetails = ({
  eventId,
  indexName
}) => {
  var _getAlertIndexAlias;
  const currentSpaceId = (0, _use_space_id.useSpaceId)();
  // TODO Replace getAlertIndexAlias way to retrieving the eventIndex with the GET /_alias
  //  https://github.com/elastic/kibana/issues/113063
  const eventIndex = indexName ? (_getAlertIndexAlias = (0, _helpers.getAlertIndexAlias)(indexName, currentSpaceId)) !== null && _getAlertIndexAlias !== void 0 ? _getAlertIndexAlias : indexName : '';
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const sourcererScope = pageName === _securitySolutionNavigation.SecurityPageName.detections ? _model.SourcererScopeName.detections : _model.SourcererScopeName.default;
  const sourcererDataView = (0, _sourcerer.useSourcererDataView)(sourcererScope);
  const [loading, dataFormattedForFieldBrowser, searchHit, dataAsNestedObject, refetchFlyoutData] = (0, _details.useTimelineEventsDetails)({
    indexName: eventIndex,
    eventId: eventId !== null && eventId !== void 0 ? eventId : '',
    runtimeMappings: sourcererDataView.runtimeMappings,
    skip: !eventId
  });
  const getFieldsData = (0, _use_get_fields_data.useGetFieldsData)(searchHit === null || searchHit === void 0 ? void 0 : searchHit.fields);
  return {
    browserFields: sourcererDataView.browserFields,
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    getFieldsData,
    indexPattern: sourcererDataView.indexPattern,
    loading,
    refetchFlyoutData,
    searchHit
  };
};
exports.useEventDetails = useEventDetails;