"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AboutSection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _expandable_section = require("./expandable_section");
var _test_ids = require("./test_ids");
var _description = require("./description");
var _reason = require("./reason");
var _mitre_attack = require("./mitre_attack");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Most top section of the overview tab. It contains the description, reason and mitre attack information (for a document of type alert).
 */
const AboutSection = ({
  expanded = true
}) => {
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.about.sectionTitle",
      defaultMessage: "About"
    }),
    "data-test-subj": _test_ids.ABOUT_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_description.Description, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_reason.Reason, null), /*#__PURE__*/_react.default.createElement(_mitre_attack.MitreAttack, null));
};
exports.AboutSection = AboutSection;
AboutSection.displayName = 'AboutSection';