"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePreviewPanel = exports.PreviewPanel = exports.DocumentDetailsPreviewPanelKey = exports.AlertReasonPreviewPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _panels = require("./panels");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulePreviewPanel = 'rule-preview';
exports.RulePreviewPanel = RulePreviewPanel;
const AlertReasonPreviewPanel = 'alert-reason-preview';
exports.AlertReasonPreviewPanel = AlertReasonPreviewPanel;
const DocumentDetailsPreviewPanelKey = 'document-details-preview';
exports.DocumentDetailsPreviewPanelKey = DocumentDetailsPreviewPanelKey;
/**
 * Preview panel to be displayed on top of the document details expandable flyout right section
 */
const PreviewPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const previewPanel = (0, _react.useMemo)(() => {
    return path ? _panels.panels.find(panel => panel.id === path.tab) : null;
  }, [path]);
  if (!previewPanel) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    gutterSize: "none",
    style: {
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      marginTop: '-15px'
    }
  }, previewPanel.content), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, previewPanel.footer));
});
exports.PreviewPanel = PreviewPanel;
PreviewPanel.displayName = 'PreviewPanel';